/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.handler;

import com.mz.mobaspects.aspect.handler.IAspectHandler;
import com.mz.mobaspects.capability.aspect.AspectCapabilityProvider;
import com.mz.mobaspects.constants.CustomDamageSource;
import com.mz.mobaspects.entity.AspectShieldEntity;
import com.mz.mobaspects.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class ShieldingAspectHandler
implements IAspectHandler {
    private int cooldown = 100;
    private boolean countHitsFromPlayerOnly = true;
    private boolean instantDestroyByAxe = true;
    private int maxHits = 3;

    @Override
    public void handleOnSpawn(LivingEntity entity) {
        MobEntity mob = (MobEntity)entity;
        AspectShieldEntity followerEntity = new AspectShieldEntity(entity.field_70170_p, mob);
        followerEntity.setConfig(this.maxHits, this.cooldown);
        Utils.queueFollowerEntitySpawn(entity.field_70170_p, followerEntity, (MobEntity)entity);
    }

    @Override
    public void handlePreReceiveHit(LivingEntity victim, LivingHurtEvent evt) {
        if (CustomDamageSource.STOIC_DAMAGE_SOURCE.equals(evt.getSource()) || evt.isCanceled()) {
            return;
        }
        if (this.countHitsFromPlayerOnly && !(evt.getSource().func_76346_g() instanceof PlayerEntity)) {
            return;
        }
        boolean isAxe = this.instantDestroyByAxe && this.isDamageByAxe(evt.getSource().func_76364_f());
        victim.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(extraInfo -> extraInfo.getAspectFollowers().stream().filter(followerEntity -> followerEntity instanceof AspectShieldEntity).findFirst().map(followerEntity -> (AspectShieldEntity)((Object)((Object)followerEntity))).filter(AspectShieldEntity::isActive).ifPresent(shield -> {
            shield.takeHit(isAxe);
            evt.setCanceled(true);
        }));
    }

    private boolean isDamageByAxe(Entity damageCauser) {
        if (!(damageCauser instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)damageCauser;
        return living.func_184614_ca().func_77973_b() instanceof AxeItem;
    }

    public void setConfig(int maxHits, int cooldown, boolean instantDestroyByAxe, boolean countHitsFromPlayerOnly) {
        this.instantDestroyByAxe = instantDestroyByAxe;
        this.cooldown = cooldown;
        this.maxHits = maxHits;
        this.countHitsFromPlayerOnly = countHitsFromPlayerOnly;
    }
}

