/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.handler;

import com.mz.mobaspects.aspect.handler.IAspectHandler;
import com.mz.mobaspects.util.Utils;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.event.entity.living.LivingDamageEvent;

public class SirenAspectHandler
implements IAspectHandler {
    private float sirenLureRadius = 32.0f;
    private float sirenUseChance = 0.5f;
    private int sirenLureCount = 2;

    @Override
    public void handleOnReceiveHitServer(Entity attacker, LivingEntity victim, float amount, DamageSource damageSource, LivingDamageEvent evt) {
        if (!(victim instanceof MobEntity)) {
            return;
        }
        if (victim.func_70681_au().nextDouble() > (double)this.sirenUseChance) {
            return;
        }
        List<MobEntity> nearByMobs = Utils.findNearbyMobs((Entity)((MobEntity)victim), victim.func_130014_f_(), this.sirenLureRadius);
        if (nearByMobs.size() == 0) {
            return;
        }
        victim.func_184185_a(SoundEvents.field_187532_aV, 0.9f, 2.0f);
        Collections.shuffle(nearByMobs);
        for (int i = 0; i < nearByMobs.size() && i < this.sirenLureCount; ++i) {
            MobEntity mob = nearByMobs.get(i);
            mob.getPersistentData().func_74768_a("mobaspects_SirenMoveToId", victim.func_145782_y());
        }
    }

    public void setConfig(float sirenLureRadius, float sirenUseChance, int sirenLureCount) {
        this.sirenLureRadius = sirenLureRadius;
        this.sirenUseChance = sirenUseChance;
        this.sirenLureCount = sirenLureCount;
    }
}

