/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.handler;

import com.mz.mobaspects.aspect.goal.StoicTakeDamageGoal;
import com.mz.mobaspects.aspect.handler.IAspectHandler;
import com.mz.mobaspects.constants.CustomDamageSource;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class StoicAspectHandler
implements IAspectHandler {
    public static String NBT_STOIC_DAMAGE_POOL = "STOIC_DAMAGE_POOL";
    private float maxDamageCanTake = 8.0f;
    private int ticksPerTakeDamage = 20;

    @Override
    public void handleOnSpawn(LivingEntity entity) {
        MobEntity mob = (MobEntity)entity;
        mob.field_70714_bg.func_75776_a(0, (Goal)new StoicTakeDamageGoal(mob, this.ticksPerTakeDamage, this.maxDamageCanTake));
    }

    @Override
    public void handlePreReceiveHit(LivingEntity victim, LivingHurtEvent evt) {
        DamageSource source = evt.getSource();
        if (!CustomDamageSource.STOIC_DAMAGE_SOURCE.equals(source)) {
            float amount = evt.getAmount();
            float damage = victim.getPersistentData().func_74760_g(NBT_STOIC_DAMAGE_POOL);
            victim.getPersistentData().func_74776_a(NBT_STOIC_DAMAGE_POOL, damage += amount);
            evt.setAmount(0.0f);
        }
    }

    public void setConfig(float maxDamageCanTake, int ticksPerTakeDamage) {
        this.maxDamageCanTake = maxDamageCanTake;
        this.ticksPerTakeDamage = ticksPerTakeDamage;
    }
}

