/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.aspect.handler;

import com.mz.mobaspects.aspect.handler.IAspectHandler;
import com.mz.mobaspects.util.EntityAttributeUtils;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;

public class SwiftAspectHandler
implements IAspectHandler {
    private static final UUID SPEED_MODIFIER_IDENTIFIER = UUID.fromString("e8cd0880-e1fe-4afb-8ec5-72ea415b8a85");
    private static final UUID ATTACK_SPEED_MODIFIER_IDENTIFIER = UUID.fromString("7994d8b7-df9f-4129-973a-638d2f857742");
    private float speedMultiplier = 0.5f;
    private float attackSpeedMultiplier = 0.3f;

    @Override
    public void handleOnSpawn(LivingEntity entity) {
        EntityAttributeUtils.ApplyAttributeModifier(entity, Attributes.field_233821_d_, SPEED_MODIFIER_IDENTIFIER, this.speedMultiplier, AttributeModifier.Operation.MULTIPLY_TOTAL, "Swift speed increase");
        EntityAttributeUtils.ApplyAttributeModifier(entity, Attributes.field_233825_h_, ATTACK_SPEED_MODIFIER_IDENTIFIER, this.attackSpeedMultiplier, AttributeModifier.Operation.MULTIPLY_TOTAL, "Swift attack speed increase");
    }

    public void setConfig(float speedMultiplier, float attackSpeedMultiplier) {
        this.speedMultiplier = speedMultiplier;
        this.attackSpeedMultiplier = attackSpeedMultiplier;
    }
}

