/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.capability;

import com.mz.mobaspects.aspect.core.AspectManager;
import com.mz.mobaspects.aspect.core.IAspectMob;
import com.mz.mobaspects.capability.aspect.AspectCapabilityProvider;
import com.mz.mobaspects.network.NetworkHandler;
import com.mz.mobaspects.network.message.MobAspectMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class CapabilityEventHandler {
    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
        Entity entity = (Entity)evt.getObject();
        if (AspectManager.INSTANCE.canAttachAspect(entity)) {
            AspectCapabilityProvider provider = new AspectCapabilityProvider((LivingEntity)entity);
            evt.addCapability(new ResourceLocation("mobaspects", "mobaspects"), (ICapabilityProvider)provider);
            evt.addListener(provider::invalidate);
        }
    }

    @SubscribeEvent
    public void startTracking(PlayerEvent.StartTracking evt) {
        Entity entity = evt.getTarget();
        PlayerEntity playerEntity = evt.getPlayer();
        if (!(playerEntity instanceof ServerPlayerEntity)) {
            return;
        }
        entity.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(aspectMob -> NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)playerEntity), (Object)new MobAspectMessage(entity, (IAspectMob)aspectMob)));
    }
}

