/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.capability.aspect;

import com.mz.mobaspects.aspect.core.IAspectMob;
import com.mz.mobaspects.constants.AspectEnum;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;

public class AspectStorage
implements Capability.IStorage<IAspectMob> {
    @Nullable
    public INBT writeNBT(Capability<IAspectMob> capability, IAspectMob instance, Direction side) {
        CompoundNBT compoundNBT = new CompoundNBT();
        Set<AspectEnum> aspectCodeList = instance.getAspectCodes();
        compoundNBT.func_197646_b("mobaspects_attributes", AspectStorage.aspectEnumToId(aspectCodeList));
        return compoundNBT;
    }

    public void readNBT(Capability<IAspectMob> capability, IAspectMob instance, Direction side, INBT nbt) {
        CompoundNBT compoundNBT = (CompoundNBT)nbt;
        if (compoundNBT.func_74764_b("mobaspects_attributes")) {
            int[] codeArray = compoundNBT.func_74759_k("mobaspects_attributes");
            instance.setAspectCodes(AspectStorage.aspectIdToEnum(codeArray));
        }
    }

    private static List<Integer> aspectEnumToId(Collection<AspectEnum> aspectCodeList) {
        return aspectCodeList.stream().map(AspectEnum::getId).collect(Collectors.toList());
    }

    private static Set<AspectEnum> aspectIdToEnum(int[] aspectIdAry) {
        return Arrays.stream(aspectIdAry).mapToObj(AspectEnum::fromId).collect(Collectors.toSet());
    }
}

