/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.entity;

import com.mz.mobaspects.entity.AbstractAspectFollowerEntity;
import com.mz.mobaspects.entity.CustomEntityRegister;
import com.mz.mobaspects.network.NetworkHandler;
import com.mz.mobaspects.network.message.EntityActionEnum;
import com.mz.mobaspects.network.message.EntityActionMessage;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class AspectShieldEntity
extends AbstractAspectFollowerEntity {
    private int nextUse = 0;
    private int cooldown = 160;
    private int currentHits = 0;
    private int maxHits = 3;
    private boolean canRender = true;
    private final ItemStack shieldItemStack = new ItemStack((IItemProvider)Items.field_185159_cQ, 1);

    public AspectShieldEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public AspectShieldEntity(World worldIn, MobEntity aspectOwner) {
        super((EntityType)CustomEntityRegister.ASPECT_SHIELD.get(), worldIn, aspectOwner);
    }

    public void setConfig(int maxHits, int cooldown) {
        this.cooldown = cooldown;
        this.maxHits = maxHits;
    }

    @Override
    protected void tickServer() {
        this.tickCooldown();
    }

    public void takeHit(boolean isAxe) {
        if (this.currentHits >= this.maxHits) {
            return;
        }
        this.currentHits = isAxe ? this.maxHits : (this.currentHits = this.currentHits + 1);
        this.func_184185_a(SoundEvents.field_187767_eL, 1.0f, 1.0f);
        if (this.currentHits >= this.maxHits) {
            this.nextUse = this.cooldown;
            this.func_184185_a(SoundEvents.field_187769_eM, 1.0f, 1.0f);
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new EntityActionMessage(this.func_145782_y(), EntityActionEnum.SHIELD_BREAK));
        }
    }

    private void tickCooldown() {
        if (this.currentHits < this.maxHits) {
            return;
        }
        --this.nextUse;
        if (this.nextUse <= 0) {
            this.currentHits = 0;
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new EntityActionMessage(this.func_145782_y(), EntityActionEnum.SHIELD_ACTIVE));
        }
    }

    public boolean isActive() {
        return this.currentHits < this.maxHits;
    }

    public void clientSideShieldBreak() {
        this.canRender = false;
        for (int i = 0; i < 5; ++i) {
            this.addBreakParticle();
        }
    }

    public void clientSideShieldActive() {
        this.canRender = true;
    }

    private void addBreakParticle() {
        Vector3d vector3d = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
        vector3d = vector3d.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
        vector3d = vector3d.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
        double d0 = (double)(-this.field_70146_Z.nextFloat()) * 0.6 - 0.3;
        Vector3d vector3d1 = new Vector3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.3, d0, 0.6);
        vector3d1 = vector3d1.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
        vector3d1 = vector3d1.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
        vector3d1 = vector3d1.func_72441_c(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.shieldItemStack), vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, vector3d.field_72450_a, vector3d.field_72448_b + 0.05, vector3d.field_72449_c);
    }

    public boolean canRender() {
        return this.canRender;
    }
}

