/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.entity;

import com.mz.mobaspects.entity.AbstractAspectFollowerEntity;
import com.mz.mobaspects.entity.CustomEntityRegister;
import com.mz.mobaspects.network.NetworkHandler;
import com.mz.mobaspects.network.message.EntityActionEnum;
import com.mz.mobaspects.network.message.EntityActionMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class OverloadCrystalEntity
extends AbstractAspectFollowerEntity {
    private int currentHits = 0;
    private int maxHits = 5;
    private int currentTicksToReduceHitCount = 0;
    private int ticksToReduceHitCount = 50;
    private boolean fused = false;
    private int currentTicksBeforeExplosion = 0;
    private int ticksBeforeExplosion = 100;
    private float explosionRadius = 5.0f;
    private int innerRotation = this.field_70146_Z.nextInt(100000);

    public OverloadCrystalEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public OverloadCrystalEntity(World worldIn, MobEntity aspectOwner) {
        super((EntityType)CustomEntityRegister.OVERLOAD_CRYSTAL.get(), worldIn, aspectOwner);
    }

    public void setConfig(int maxHits, int ticksToReduceHitCount, int ticksBeforeExplosion, float explosionRadius) {
        this.maxHits = maxHits;
        this.ticksToReduceHitCount = ticksToReduceHitCount;
        this.ticksBeforeExplosion = ticksBeforeExplosion;
        this.explosionRadius = explosionRadius;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.innerRotation;
    }

    @Override
    protected void tickServer() {
        this.tickExplode();
        this.tickReduceHitCount();
    }

    public void takeHit() {
        if (this.fused) {
            return;
        }
        ++this.currentHits;
        if (this.currentHits >= this.maxHits) {
            this.fused = true;
            this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 1.0f);
            this.sendUpdateMessage(true);
        }
    }

    private void tickExplode() {
        if (!this.fused) {
            return;
        }
        ++this.currentTicksBeforeExplosion;
        if (this.currentTicksBeforeExplosion >= this.ticksBeforeExplosion) {
            this.fused = false;
            this.currentTicksBeforeExplosion = 0;
            this.currentHits = 0;
            this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.explosionRadius, Explosion.Mode.NONE);
            this.sendUpdateMessage(false);
        }
    }

    private void tickReduceHitCount() {
        if (this.currentHits <= 0 || this.fused) {
            return;
        }
        ++this.currentTicksToReduceHitCount;
        if (this.currentTicksToReduceHitCount >= this.ticksToReduceHitCount) {
            --this.currentHits;
            this.currentTicksToReduceHitCount = 0;
        }
    }

    private void sendUpdateMessage(boolean isFused) {
        if (isFused) {
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new EntityActionMessage(this.func_145782_y(), EntityActionEnum.OVERLOAD_CRYSTAL_FUSE_ON));
        } else {
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new EntityActionMessage(this.func_145782_y(), EntityActionEnum.OVERLOAD_CRYSTAL_FUSE_OFF));
        }
    }

    public boolean isFused() {
        return this.fused;
    }

    public void setFused(boolean fused) {
        this.fused = fused;
    }

    public int getInnerRotation() {
        return this.innerRotation;
    }
}

