/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.entity;

import com.mz.mobaspects.aspect.core.AspectManager;
import com.mz.mobaspects.capability.aspect.AspectCapabilityProvider;
import com.mz.mobaspects.constants.AspectEnum;
import com.mz.mobaspects.entity.CustomEntityRegister;
import com.mz.mobaspects.network.NetworkHandler;
import com.mz.mobaspects.network.message.MobAspectMessage;
import com.mz.mobaspects.util.EntityAttributeUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class ParasiteEntity
extends MonsterEntity {
    private static final UUID KNOCKBACK_MODIFIER_IDENTIFIER = UUID.fromString("9b5b0d49-3666-4f3e-b836-ac62ea229a8e");
    private LivingEntity mobAttaching;
    private int currentTicks = 0;
    private int ticksToAttach = 60;
    private Set<AspectEnum> carryingAspects = new HashSet<AspectEnum>();

    public ParasiteEntity(EntityType<? extends ParasiteEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public ParasiteEntity(World worldIn, Set<AspectEnum> carryingAspects, int ticksToAttach) {
        super((EntityType)CustomEntityRegister.ASPECT_PARASITE.get(), worldIn);
        this.carryingAspects = carryingAspects;
        this.ticksToAttach = ticksToAttach;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MonsterEntity.class, true));
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.mobAttaching != null) {
            return true;
        }
        if (entityIn instanceof ParasiteEntity) {
            return true;
        }
        if (entityIn instanceof MonsterEntity) {
            this.mobAttaching = (MonsterEntity)entityIn;
            ((MonsterEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_188423_x, 120));
            this.func_195064_c(new EffectInstance(Effects.field_188423_x, 120));
            EntityAttributeUtils.ApplyAttributeModifier((LivingEntity)((MonsterEntity)entityIn), Attributes.field_233820_c_, KNOCKBACK_MODIFIER_IDENTIFIER, 1.0f, AttributeModifier.Operation.ADDITION, "Parasite knockback immune");
            EntityAttributeUtils.ApplyAttributeModifier((LivingEntity)this, Attributes.field_233820_c_, KNOCKBACK_MODIFIER_IDENTIFIER, 1.0f, AttributeModifier.Operation.ADDITION, "Parasite knockback immune");
        }
        return true;
    }

    private void attachToMob() {
        this.mobAttaching.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(aspectMob -> {
            HashSet<AspectEnum> aspectsToAdd = new HashSet<AspectEnum>(this.carryingAspects);
            aspectsToAdd.removeAll(aspectMob.getAspectCodes());
            aspectsToAdd.forEach(code -> AspectManager.INSTANCE.getAspect((AspectEnum)((Object)((Object)code))).getHandler().handleOnSpawn(this.mobAttaching));
            aspectMob.getAspectCodes().addAll(aspectsToAdd);
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new MobAspectMessage(this.mobAttaching.func_145782_y(), aspectMob.getAspectCodes()));
        });
        EntityAttributeUtils.removeAttributeModifier(this.mobAttaching, Attributes.field_233820_c_, KNOCKBACK_MODIFIER_IDENTIFIER);
        this.func_70106_y();
    }

    public void func_70071_h_() {
        this.field_70761_aq = this.field_70177_z;
        if (!this.field_70170_p.field_72995_K) {
            if (this.mobAttaching != null && !this.mobAttaching.func_70089_S()) {
                this.mobAttaching = null;
                EntityAttributeUtils.removeAttributeModifier((LivingEntity)this, Attributes.field_233820_c_, KNOCKBACK_MODIFIER_IDENTIFIER);
                this.currentTicks = 0;
            } else if (this.func_70089_S() && this.mobAttaching != null && this.currentTicks < this.ticksToAttach) {
                ++this.currentTicks;
                if (this.currentTicks >= this.ticksToAttach) {
                    this.attachToMob();
                }
            }
        }
        super.func_70071_h_();
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.13f;
    }

    public static AttributeModifierMap.MutableAttribute getCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 1.0);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187535_aY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187590_ba;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187536_aZ;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187592_bb, 0.15f, 1.0f);
    }

    public void func_181013_g(float offset) {
        this.field_70177_z = offset;
        super.func_181013_g(offset);
    }

    public double func_70033_W() {
        return 0.1;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0);
            }
        }
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }
}

