/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.entity;

import com.mz.mobaspects.effects.CustomEffect;
import com.mz.mobaspects.entity.AbstractAspectFollowerEntity;
import com.mz.mobaspects.entity.CustomEntityRegister;
import com.mz.mobaspects.network.NetworkHandler;
import com.mz.mobaspects.network.message.EntityActionEnum;
import com.mz.mobaspects.network.message.EntityActionMessage;
import com.mz.mobaspects.util.Utils;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class UndyingTotemAspectEntity
extends AbstractAspectFollowerEntity {
    private int abilityNextUse = 120;
    private int abilityCooldown = 120;
    private int abilityDurationRemain = 0;
    private int abilityDuration = 120;
    private int effectDuration = 20;
    private float range = 5.0f;
    private boolean isAuraActive = false;
    private boolean forceActivated = false;

    public UndyingTotemAspectEntity(EntityType<?> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    public UndyingTotemAspectEntity(World worldIn, MobEntity aspectOwner) {
        super((EntityType)CustomEntityRegister.UNDYING_TOTEM.get(), worldIn, aspectOwner);
    }

    public void setConfig(int abilityCooldown, int abilityDuration, int effectDuration, float range) {
        this.abilityCooldown = abilityCooldown;
        this.abilityDuration = abilityDuration;
        this.effectDuration = effectDuration;
        this.range = range;
        this.abilityNextUse = abilityCooldown;
    }

    @Override
    protected void tickServer() {
        this.checkAndUseAbility();
    }

    public void forceActivate() {
        if (this.forceActivated) {
            return;
        }
        this.forceActivated = true;
        this.activateAura();
    }

    public void activateAura() {
        this.abilityDurationRemain = this.abilityDuration;
        this.isAuraActive = true;
        this.sendUpdateMessage(true);
    }

    private void checkAndUseAbility() {
        if (this.isAuraActive) {
            --this.abilityDurationRemain;
            this.applyAuraEffect();
            if (this.abilityDurationRemain <= 0) {
                this.isAuraActive = false;
                this.sendUpdateMessage(false);
                this.abilityNextUse = this.abilityCooldown;
            }
        } else {
            if (this.abilityNextUse > 0) {
                --this.abilityNextUse;
                return;
            }
            this.activateAura();
        }
    }

    private void applyAuraEffect() {
        List<LivingEntity> nearbyLivingEntities = Utils.findNearbyLivingEntities(this, this.func_130014_f_(), this.range);
        if (nearbyLivingEntities.size() == 0) {
            return;
        }
        for (LivingEntity livingEntity : nearbyLivingEntities) {
            livingEntity.func_195064_c(new EffectInstance(CustomEffect.UNDYING, this.effectDuration));
        }
    }

    private void sendUpdateMessage(boolean isAuraActive) {
        if (isAuraActive) {
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new EntityActionMessage(this.func_145782_y(), EntityActionEnum.UNDYING_TOTEM_ACTIVE));
        } else {
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new EntityActionMessage(this.func_145782_y(), EntityActionEnum.UNDYING_TOTEM_DEACTIVE));
        }
    }

    public boolean isAuraActive() {
        return this.isAuraActive;
    }

    public void setAuraActive(boolean isAuraActive) {
        this.isAuraActive = isAuraActive;
    }

    public float getRange() {
        return this.range;
    }
}

