/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.events.gui;

import com.mz.mobaspects.capability.aspect.AspectCapabilityProvider;
import com.mz.mobaspects.constants.AspectEnum;
import com.mz.mobaspects.util.RaytraceHelper;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class UiEventHandler {
    private static final String TRANSLATION_PREFIX = "aspect.name.";

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (!Minecraft.func_71382_s() || event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Optional<LivingEntity> livingEntity = RaytraceHelper.getLookAtMobAspect(mc, event.getPartialTicks());
        livingEntity.ifPresent(entity -> entity.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(aspectMob -> {
            Set<AspectEnum> aspectCodeList = aspectMob.getAspectCodes();
            if (aspectCodeList.size() == 0) {
                return;
            }
            int xOffset = (int)((double)mc.func_228018_at_().func_198107_o() * 0.05);
            int yOffset = (int)((double)mc.func_228018_at_().func_198087_p() * 0.1);
            for (AspectEnum aspect : aspectCodeList) {
                mc.field_71466_p.func_243246_a(event.getMatrixStack(), (ITextComponent)new TranslationTextComponent(TRANSLATION_PREFIX + aspect.getName()), (float)xOffset, (float)yOffset, TextFormatting.RED.func_211163_e().intValue());
                yOffset += 20;
            }
        }));
    }
}

