/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.network.message;

import com.mz.mobaspects.aspect.core.IAspectMob;
import com.mz.mobaspects.capability.aspect.AspectCapabilityProvider;
import com.mz.mobaspects.constants.AspectEnum;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MobAspectMessage {
    private int entityId;
    private int aspectCount;
    private Set<AspectEnum> aspectCodes;

    public MobAspectMessage() {
    }

    public MobAspectMessage(Entity entity, IAspectMob aspectMob) {
        this(entity.func_145782_y(), aspectMob.getAspectCodes());
    }

    public MobAspectMessage(int entityId, Set<AspectEnum> aspectCodes) {
        this.entityId = entityId;
        this.aspectCount = aspectCodes.size();
        this.aspectCodes = aspectCodes;
    }

    public static void encode(MobAspectMessage message, PacketBuffer buffer) {
        buffer.writeInt(message.entityId);
        buffer.writeInt(message.aspectCount);
        message.aspectCodes.forEach(arg_0 -> ((PacketBuffer)buffer).func_179249_a(arg_0));
    }

    public static MobAspectMessage decode(PacketBuffer buffer) {
        MobAspectMessage message = new MobAspectMessage();
        message.entityId = buffer.readInt();
        message.aspectCount = buffer.readInt();
        message.aspectCodes = new HashSet<AspectEnum>();
        for (int i = 0; i < message.aspectCount; ++i) {
            message.aspectCodes.add((AspectEnum)buffer.func_179257_a(AspectEnum.class));
        }
        return message;
    }

    public static void handle(MobAspectMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            if (world != null && (entity = world.func_73045_a(message.entityId)) != null) {
                entity.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(aspectMob -> aspectMob.setAspectCodes(message.aspectCodes));
            }
        });
        context.setPacketHandled(true);
    }
}

