/*
 * Decompiled with CFR 0.152.
 */
package com.mz.mobaspects.util;

import com.mz.mobaspects.aspect.core.IAspectMob;
import com.mz.mobaspects.capability.aspect.AspectCapabilityProvider;
import com.mz.mobaspects.constants.AspectEnum;
import com.mz.mobaspects.entity.AbstractAspectFollowerEntity;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class Utils {
    private Utils() {
    }

    public static List<MobEntity> findNearbyMobs(Entity source, World world, float radius) {
        AxisAlignedBB range = new AxisAlignedBB(source.func_226277_ct_() - (double)radius, source.func_226278_cu_() - (double)radius, source.func_226281_cx_() - (double)radius, source.func_226277_ct_() + (double)radius, source.func_226278_cu_() + (double)radius, source.func_226281_cx_() + (double)radius);
        List mobEntityList = world.func_217357_a(MobEntity.class, range);
        if (source instanceof MobEntity) {
            mobEntityList.remove(source);
        }
        return mobEntityList;
    }

    public static List<LivingEntity> findNearbyLivingEntities(Entity source, World world, float radius) {
        AxisAlignedBB range = new AxisAlignedBB(source.func_226277_ct_() - (double)radius, source.func_226278_cu_() - (double)radius, source.func_226281_cx_() - (double)radius, source.func_226277_ct_() + (double)radius, source.func_226278_cu_() + (double)radius, source.func_226281_cx_() + (double)radius);
        return world.func_217357_a(LivingEntity.class, range);
    }

    public static boolean hasAspect(MobEntity mob, AspectEnum aspect) {
        return mob.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).filter(iAspectMob -> iAspectMob.getAspectCodes().contains((Object)aspect)).isPresent();
    }

    public static Set<AspectEnum> getAspects(LivingEntity entity) {
        return entity.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).map(IAspectMob::getAspectCodes).orElse(new HashSet());
    }

    public static void queueFollowerEntitySpawn(World world, AbstractAspectFollowerEntity followerEntity, MobEntity ownerEntity) {
        ThreadTaskExecutor executor = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(world.field_72995_K ? LogicalSide.CLIENT : LogicalSide.SERVER);
        executor.func_212871_a_((Runnable)new TickDelayedTask(0, () -> {
            world.func_217376_c((Entity)followerEntity);
            ownerEntity.getCapability(AspectCapabilityProvider.ASPECT_CAPABILITY).ifPresent(extraInfo -> extraInfo.addAspectFollower(followerEntity));
        }));
    }

    public static float getHealthPercentage(LivingEntity entity) {
        return entity.func_110143_aJ() / entity.func_110138_aP();
    }

    public static void dropItemIntoWorld(World world, BlockPos pos, ItemStack item) {
        Random rand = new Random();
        if (item != null && item.func_190916_E() > 0) {
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            ItemEntity entityItem = new ItemEntity(world, (double)((float)pos.func_177958_n() + rx), (double)((float)pos.func_177956_o() + ry), (double)((float)pos.func_177952_p() + rz), item.func_77946_l());
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d(item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.func_213293_j(rand.nextGaussian() * (double)factor, rand.nextGaussian() * (double)factor + (double)0.2f, rand.nextGaussian() * (double)factor);
            world.func_217376_c((Entity)entityItem);
            item.func_190920_e(0);
        }
    }
}

