/*
 * Decompiled with CFR 0.152.
 */
package cinnamon.ofc;

import cinnamon.ofc.Config;
import cinnamon.ofc.Mod;
import cinnamon.ofc.forge.HandPlatformImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.nio.file.Path;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class HandPlatform {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigDirectory() {
        return HandPlatformImpl.getConfigDirectory();
    }

    public static boolean canUseOffhand(Entity entity) {
        return entity instanceof Player;
    }

    public static void attack(Player player, Entity targetEntity) {
        int halfTick;
        Mod.get((Player)player).doOverride = false;
        ItemStack offhand = player.m_21206_();
        ItemStack mainHand = player.m_21205_();
        Mod.Data data = Mod.get(player);
        int ticksSinceLastSwingOff = data.attackStrengthTicker;
        int ticksSinceLastSwingMain = player.f_20922_;
        HandPlatform.setItemStackToSlot(player, EquipmentSlot.MAINHAND, offhand);
        HandPlatform.setItemStackToSlot(player, EquipmentSlot.OFFHAND, mainHand);
        HandPlatform.makeActive(player, offhand, mainHand);
        player.f_20922_ = ticksSinceLastSwingOff;
        player.m_5706_(targetEntity);
        player.f_20922_ = ticksSinceLastSwingMain;
        data.attackStrengthTicker = 0;
        if (HandPlatform.canSwingHand(player, InteractionHand.MAIN_HAND) && ticksSinceLastSwingMain > (halfTick = (int)(Config.Runtime.attackTimeoutAfterSwing * (double)player.m_36333_()))) {
            player.f_20922_ = halfTick;
        }
        HandPlatform.setItemStackToSlot(player, EquipmentSlot.OFFHAND, offhand);
        HandPlatform.setItemStackToSlot(player, EquipmentSlot.MAINHAND, mainHand);
        HandPlatform.makeInactive(player, offhand, mainHand);
    }

    public static void resetAttackStrengthTickerMainHand(Player player) {
        if (HandPlatform.canSwingHand(player, InteractionHand.OFF_HAND)) {
            Mod.Data data = Mod.get(player);
            int ticksSinceLastSwingOff = data.attackStrengthTicker;
            ItemStack offhand = player.m_21206_();
            ItemStack mainHand = player.m_21205_();
            HandPlatform.makeActive(player, offhand, mainHand);
            int halfTick = (int)(Config.Runtime.attackTimeoutAfterSwing * (double)player.m_36333_());
            HandPlatform.makeInactive(player, offhand, mainHand);
            if (ticksSinceLastSwingOff > halfTick) {
                data.attackStrengthTicker = halfTick;
            }
        }
    }

    public static void resetAttackStrengthTickerOffHand(Player player) {
        int halfTick;
        Mod.Data data = Mod.get(player);
        data.attackStrengthTicker = 0;
        if (HandPlatform.canSwingHand(player, InteractionHand.MAIN_HAND) && player.f_20922_ > (halfTick = (int)(Config.Runtime.attackTimeoutAfterSwing * (double)player.m_36333_()))) {
            player.f_20922_ = halfTick;
        }
    }

    public static boolean canSwingHand(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        return stack.m_41638_(hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND).containsKey((Object)Attributes.f_22281_) || stack.m_41638_(EquipmentSlot.MAINHAND).containsKey((Object)Attributes.f_22281_);
    }

    public static void makeActive(Player playerIn, ItemStack offhand, ItemStack mainHand) {
        playerIn.m_21204_().m_22161_(mainHand.m_41638_(EquipmentSlot.MAINHAND));
        playerIn.m_21204_().m_22161_(offhand.m_41638_(EquipmentSlot.OFFHAND));
        playerIn.m_21204_().m_22178_(offhand.m_41638_(EquipmentSlot.MAINHAND));
        playerIn.m_21204_().m_22178_(mainHand.m_41638_(EquipmentSlot.OFFHAND));
    }

    public static void makeInactive(Player playerIn, ItemStack offhand, ItemStack mainHand) {
        playerIn.m_21204_().m_22161_(mainHand.m_41638_(EquipmentSlot.OFFHAND));
        playerIn.m_21204_().m_22161_(offhand.m_41638_(EquipmentSlot.MAINHAND));
        playerIn.m_21204_().m_22178_(mainHand.m_41638_(EquipmentSlot.MAINHAND));
        playerIn.m_21204_().m_22178_(offhand.m_41638_(EquipmentSlot.OFFHAND));
    }

    public static void setItemStackToSlot(Player playerIn, EquipmentSlot slotIn, ItemStack stack) {
        if (slotIn == EquipmentSlot.MAINHAND) {
            playerIn.m_150109_().f_35974_.set(playerIn.m_150109_().f_35977_, (Object)stack);
        } else if (slotIn == EquipmentSlot.OFFHAND) {
            playerIn.m_150109_().f_35976_.set(0, (Object)stack);
        }
    }
}

