/*
 * Decompiled with CFR 0.152.
 */
package cinnamon.ofc.mixin;

import cinnamon.ofc.HandPlatform;
import cinnamon.ofc.Mod;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class SwingMixin
extends Entity {
    @Shadow
    public boolean f_20911_;
    @Shadow
    public int f_20913_;
    @Shadow
    public InteractionHand f_20912_;
    @Unique
    public boolean swinging_temp;
    @Unique
    public int swingTime_temp;
    @Unique
    public InteractionHand swingingArm_temp;

    public SwingMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"swing(Lnet/minecraft/world/InteractionHand;Z)V"}, at={@At(target="Lnet/minecraft/world/entity/LivingEntity;swinging:Z", value="FIELD", ordinal=0, opcode=180)})
    public void swing(InteractionHand interactionHand, boolean bl, CallbackInfo ci) {
        if (!HandPlatform.canUseOffhand(this)) {
            return;
        }
        if (interactionHand == InteractionHand.OFF_HAND) {
            HandPlatform.resetAttackStrengthTickerOffHand((Player)this);
        } else {
            HandPlatform.resetAttackStrengthTickerMainHand((Player)this);
        }
    }

    @Redirect(method={"swing(Lnet/minecraft/world/InteractionHand;Z)V"}, at=@At(target="Lnet/minecraft/world/entity/LivingEntity;swinging:Z", value="FIELD", ordinal=0, opcode=180))
    public boolean swinging(LivingEntity livingEntity, InteractionHand interactionHand, boolean bl) {
        if (!HandPlatform.canUseOffhand((Entity)livingEntity)) {
            return this.f_20911_;
        }
        Mod.Data data = Mod.get((Player)livingEntity);
        return this.f_20911_ ? (this.f_20912_ != interactionHand ? data.swinging : this.f_20911_) : this.f_20911_;
    }

    @Redirect(method={"swing(Lnet/minecraft/world/InteractionHand;Z)V"}, at=@At(target="Lnet/minecraft/world/entity/LivingEntity;swingTime:I", value="FIELD", ordinal=0, opcode=180))
    public int swingingTime(LivingEntity livingEntity, InteractionHand interactionHand, boolean bl) {
        if (!HandPlatform.canUseOffhand((Entity)livingEntity)) {
            return this.f_20913_;
        }
        Mod.Data data = Mod.get((Player)livingEntity);
        return this.f_20911_ ? (this.f_20912_ != interactionHand ? data.swingTime : this.f_20913_) : this.f_20913_;
    }

    @Redirect(method={"swing(Lnet/minecraft/world/InteractionHand;Z)V"}, at=@At(target="Lnet/minecraft/world/entity/LivingEntity;swingTime:I", value="FIELD", ordinal=1, opcode=180))
    public int swingingTime_(LivingEntity livingEntity, InteractionHand interactionHand, boolean bl) {
        if (!HandPlatform.canUseOffhand((Entity)livingEntity)) {
            return this.f_20913_;
        }
        Mod.Data data = Mod.get((Player)livingEntity);
        return this.f_20911_ ? (this.f_20912_ != interactionHand ? data.swingTime : this.f_20913_) : this.f_20913_;
    }

    @Redirect(method={"swing(Lnet/minecraft/world/InteractionHand;Z)V"}, at=@At(target="Lnet/minecraft/world/entity/LivingEntity;swingTime:I", value="FIELD", ordinal=0, opcode=181))
    public void setSwingTime(LivingEntity livingEntity, int swingTime, InteractionHand interactionHand, boolean bl) {
        if (!HandPlatform.canUseOffhand((Entity)livingEntity)) {
            livingEntity.f_20913_ = swingTime;
            return;
        }
        this.swinging_temp = this.f_20911_;
        this.swingTime_temp = this.f_20913_;
        this.swingingArm_temp = this.f_20912_;
        Mod.Data data = Mod.get((Player)livingEntity);
        if (this.swinging_temp && this.swingTime_temp < this.m_21304_() / 2 && this.swingingArm_temp != interactionHand) {
            data.swingTime = -1;
        } else {
            livingEntity.f_20913_ = swingTime;
        }
    }

    @Redirect(method={"swing(Lnet/minecraft/world/InteractionHand;Z)V"}, at=@At(target="Lnet/minecraft/world/entity/LivingEntity;swinging:Z", value="FIELD", ordinal=0, opcode=181))
    public void setSwinging(LivingEntity livingEntity, boolean swinging, InteractionHand interactionHand, boolean bl) {
        if (!HandPlatform.canUseOffhand((Entity)livingEntity)) {
            livingEntity.f_20911_ = swinging;
            return;
        }
        Mod.Data data = Mod.get((Player)livingEntity);
        if (this.swinging_temp && this.swingTime_temp < this.m_21304_() / 2 && this.swingingArm_temp != interactionHand) {
            data.swinging = true;
        } else {
            livingEntity.f_20911_ = swinging;
        }
    }

    @Redirect(method={"swing(Lnet/minecraft/world/InteractionHand;Z)V"}, at=@At(target="Lnet/minecraft/world/entity/LivingEntity;swingingArm:Lnet/minecraft/world/InteractionHand;", value="FIELD", ordinal=0, opcode=181))
    public void setSwingingArm(LivingEntity livingEntity, InteractionHand swingingArm, InteractionHand interactionHand, boolean bl) {
        if (!HandPlatform.canUseOffhand((Entity)livingEntity)) {
            livingEntity.f_20912_ = interactionHand;
            return;
        }
        Mod.Data data = Mod.get((Player)livingEntity);
        if (this.swinging_temp && this.swingTime_temp < this.m_21304_() / 2 && this.swingingArm_temp != interactionHand) {
            data.swingingArm = interactionHand;
        } else {
            livingEntity.f_20912_ = interactionHand;
        }
    }

    @Inject(method={"updateSwingTime()V"}, at={@At(value="HEAD")})
    public void updateArmSwingProgress(CallbackInfo ci) {
        if (!HandPlatform.canUseOffhand(this)) {
            return;
        }
        Mod.Data data = Mod.get((Player)this);
        int i = this.m_21304_();
        if (data.swinging) {
            ++data.swingTime;
            if (data.swingTime >= i) {
                data.swingTime = 0;
                data.swinging = false;
            }
        } else {
            data.swingTime = 0;
        }
        data.attackAnim_ = data.attackAnim;
        data.attackAnim = (float)data.swingTime / (float)i;
    }

    @Inject(method={"stopUsingItem()V"}, at={@At(value="HEAD")})
    public void resetActiveHand(CallbackInfo ci) {
        if (!HandPlatform.canUseOffhand(this)) {
            return;
        }
        if (this.m_6117_()) {
            Mod.Data data = Mod.get((Player)this);
            data.ticksSinceLastActiveStack = 0;
            data.handOfLastActiveStack = this.m_7655_();
        }
    }

    @Shadow
    public abstract boolean m_6117_();

    @Shadow
    public abstract InteractionHand m_7655_();

    @Shadow
    protected abstract int m_21304_();
}

