/*
 * Decompiled with CFR 0.152.
 */
package cinnamon.ofc;

import cinnamon.ofc.Config;
import cinnamon.ofc.HandPlatform;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.authlib.minecraft.client.ObjectMapper;
import dev.architectury.event.events.common.TickEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;

public class Mod {
    public static final String MOD_ID = "offhandcombat";
    public static Map<UUID, Data> swing = new HashMap<UUID, Data>();
    public static Map<UUID, Data> swingLocal = new HashMap<UUID, Data>();

    public static void init() {
        TickEvent.ServerLevelTick.PLAYER_POST.register(instance -> {
            Data data = Mod.get(instance);
            if (!instance.m_7578_()) {
                --data.missTime;
                ++data.attackStrengthTicker;
                ++data.ticksSinceLastActiveStack;
            }
        });
        String directory = HandPlatform.getConfigDirectory().toAbsolutePath().normalize().toString();
        Mod.makeConfig(directory);
        Mod.readConfig(directory);
    }

    public static void makeConfig(String location) {
        File file = new File(location + "/ofc.json");
        if (!file.exists()) {
            try {
                boolean newFile = file.createNewFile();
                if (newFile) {
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.add("attackTimeoutAfterSwing", (JsonElement)new JsonPrimitive((Number)Config.Runtime.attackTimeoutAfterSwing));
                    ObjectMapper objectMapper = ObjectMapper.create();
                    FileWriter fileWriter = new FileWriter(file);
                    fileWriter.write(objectMapper.writeValueAsString((Object)jsonObject));
                    fileWriter.flush();
                    fileWriter.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void readConfig(String location) {
        File file = new File(location + "/ofc.json");
        if (file.exists()) {
            try {
                JsonObject jsonObject = (JsonObject)JsonParser.parseReader((Reader)new FileReader(file));
                JsonElement attackTimeoutAfterSwing = jsonObject.get("attackTimeoutAfterSwing");
                Config.Runtime.attackTimeoutAfterSwing = attackTimeoutAfterSwing.getAsDouble();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static Data get(Player entity) {
        if (entity.m_7578_()) {
            if (!swingLocal.containsKey(entity.m_142081_())) {
                swingLocal.put(entity.m_142081_(), new Data());
            }
            return swingLocal.get(entity.m_142081_());
        }
        if (!swing.containsKey(entity.m_142081_())) {
            swing.put(entity.m_142081_(), new Data());
        }
        return swing.get(entity.m_142081_());
    }

    public static class Data {
        public boolean doOverride;
        public int missTime;
        public int swingTime;
        public boolean swinging;
        public float attackAnim;
        public float attackAnim_;
        public int attackStrengthTicker;
        public InteractionHand swingingArm;
        public int ticksSinceLastActiveStack;
        public InteractionHand handOfLastActiveStack;
    }
}

