/*
 * Decompiled with CFR 0.152.
 */
package cinnamon.ofc.forge.mixin;

import cinnamon.ofc.HandPlatform;
import cinnamon.ofc.Mod;
import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ItemInHandRenderer.class})
public abstract class HandMixin {
    @Shadow
    private float f_109304_;
    @Shadow
    private ItemStack f_109301_;

    @Redirect(method={"tick"}, at=@At(target="net/minecraft/util/Mth.clamp (FFF)F", value="INVOKE", ordinal=3))
    public float tickHand(float num, float min, float max) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return Mth.m_14036_((float)num, (float)min, (float)max);
        }
        if (!HandPlatform.canUseOffhand((Entity)player)) {
            return Mth.m_14036_((float)num, (float)min, (float)max);
        }
        ItemStack offhand = player.m_21206_();
        ItemStack mainHand = player.m_21205_();
        HandPlatform.makeActive((Player)player, offhand, mainHand);
        double attributeValue = player.m_36333_();
        HandPlatform.makeInactive((Player)player, offhand, mainHand);
        Mod.Data data = Mod.get((Player)player);
        --data.missTime;
        ++data.attackStrengthTicker;
        ++data.ticksSinceLastActiveStack;
        float f = Mth.m_14036_((float)((float)data.attackStrengthTicker / (float)attributeValue), (float)0.0f, (float)1.0f);
        boolean reequip = ForgeHooksClient.shouldCauseReequipAnimation((ItemStack)this.f_109301_, (ItemStack)offhand, (int)-1);
        return Mth.m_14036_((float)((!reequip ? f * f * f : 0.0f) - this.f_109304_), (float)-0.4f, (float)0.4f);
    }

    @Redirect(method={"renderHandsWithItems"}, at=@At(target="Lnet/minecraft/client/renderer/ItemInHandRenderer;renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", value="INVOKE", ordinal=0))
    public void renderArmWithItemMain(ItemInHandRenderer instance, AbstractClientPlayer f3, float f4, float f9, InteractionHand f13, float f, ItemStack f1, float f2, PoseStack flag1, MultiBufferSource flag2, int i) {
        this.m_109371_(f3, f4, f9, f13, this.getMainHandSwing(f4), f1, f2, flag1, flag2, i);
    }

    @Redirect(method={"renderHandsWithItems"}, at=@At(target="Lnet/minecraft/client/renderer/ItemInHandRenderer;renderArmWithItem(Lnet/minecraft/client/player/AbstractClientPlayer;FFLnet/minecraft/world/InteractionHand;FLnet/minecraft/world/item/ItemStack;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V", value="INVOKE", ordinal=1))
    public void renderArmWithItemOff(ItemInHandRenderer instance, AbstractClientPlayer f3, float f4, float f9, InteractionHand f13, float f, ItemStack f1, float f2, PoseStack flag1, MultiBufferSource flag2, int i) {
        this.m_109371_(f3, f4, f9, f13, this.getOffHandSwing(f4), f1, f2, flag1, flag2, i);
    }

    public float getMainHandSwing(float partial) {
        Mod.Data data = Mod.get((Player)Objects.requireNonNull(Minecraft.m_91087_().f_91074_));
        InteractionHand hand = (InteractionHand)MoreObjects.firstNonNull((Object)Minecraft.m_91087_().f_91074_.f_20912_, (Object)InteractionHand.MAIN_HAND);
        return data.swinging && data.swingingArm == InteractionHand.MAIN_HAND ? this.getSwingProgress(data, partial) : (hand == InteractionHand.MAIN_HAND ? Minecraft.m_91087_().f_91074_.m_21324_(partial) : 0.0f);
    }

    public float getOffHandSwing(float partial) {
        Mod.Data data = Mod.get((Player)Objects.requireNonNull(Minecraft.m_91087_().f_91074_));
        InteractionHand hand = (InteractionHand)MoreObjects.firstNonNull((Object)Minecraft.m_91087_().f_91074_.f_20912_, (Object)InteractionHand.MAIN_HAND);
        return data.swinging && data.swingingArm == InteractionHand.OFF_HAND ? this.getSwingProgress(data, partial) : (hand == InteractionHand.OFF_HAND ? Minecraft.m_91087_().f_91074_.m_21324_(partial) : 0.0f);
    }

    public float getSwingProgress(Mod.Data data, float partialTickTime) {
        float f = data.attackAnim - data.attackAnim_;
        if (f < 0.0f) {
            f += 1.0f;
        }
        return data.attackAnim_ + f * partialTickTime;
    }

    @Shadow
    protected abstract void m_109371_(AbstractClientPlayer var1, float var2, float var3, InteractionHand var4, float var5, ItemStack var6, float var7, PoseStack var8, MultiBufferSource var9, int var10);
}

