/*
 * Decompiled with CFR 0.152.
 */
package arekkuusu.offhandcombat.mixin;

import arekkuusu.offhandcombat.OHCConfig;
import arekkuusu.offhandcombat.api.capability.Capabilities;
import arekkuusu.offhandcombat.common.handler.OffHandHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerEntity.class})
public class PlayerHeldMixin {
    @Inject(method={"resetCooldown()V"}, at={@At(value="HEAD")})
    public void resetCooldown(CallbackInfo ci) {
        PlayerEntity player = (PlayerEntity)this;
        if (OffHandHandler.canSwingHand(player, Hand.OFF_HAND)) {
            int ticksSinceLastSwingOff = (Integer)Capabilities.offHand((Entity)player).map(c -> c.ticksSinceLastSwing).orElse((Object)0);
            ItemStack offhand = player.func_184592_cb();
            ItemStack mainHand = player.func_184614_ca();
            OffHandHandler.makeActive(player, offhand, mainHand);
            int halfTick = (int)(OHCConfig.Runtime.attackCooldownSetAfterSwing * (double)player.func_184818_cX());
            OffHandHandler.makeInactive(player, offhand, mainHand);
            if (ticksSinceLastSwingOff > halfTick) {
                Capabilities.offHand((Entity)player).ifPresent(c -> {
                    c.ticksSinceLastSwing = halfTick;
                });
            }
        }
    }
}

