/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.refinedpalette.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.refinedpalette.world.features.ores.BubblySandFeature;
import net.mcreator.refinedpalette.world.features.ores.SaltOreFeature;
import net.mcreator.refinedpalette.world.features.plants.CucumberPlantFeature;
import net.mcreator.refinedpalette.world.features.plants.LettucePlantFeature;
import net.mcreator.refinedpalette.world.features.plants.MaizePlantFeature;
import net.mcreator.refinedpalette.world.features.plants.MysticPlantFeature;
import net.mcreator.refinedpalette.world.features.plants.OnionPlantFeature;
import net.mcreator.refinedpalette.world.features.plants.RicePlantFeature;
import net.mcreator.refinedpalette.world.features.plants.StrawberryBushFeature;
import net.mcreator.refinedpalette.world.features.plants.TallBushFeature;
import net.mcreator.refinedpalette.world.features.plants.TomatoPlantFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class RefinedPaletteModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"refined_palette");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> SALT_ORE = RefinedPaletteModFeatures.register("salt_ore", SaltOreFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, SaltOreFeature.GENERATE_BIOMES, SaltOreFeature::placedFeature));
    public static final RegistryObject<Feature<?>> STRAWBERRY_BUSH = RefinedPaletteModFeatures.register("strawberry_bush", StrawberryBushFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, StrawberryBushFeature.GENERATE_BIOMES, StrawberryBushFeature::placedFeature));
    public static final RegistryObject<Feature<?>> TALL_BUSH = RefinedPaletteModFeatures.register("tall_bush", TallBushFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, TallBushFeature.GENERATE_BIOMES, TallBushFeature::placedFeature));
    public static final RegistryObject<Feature<?>> MYSTIC_PLANT = RefinedPaletteModFeatures.register("mystic_plant", MysticPlantFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, MysticPlantFeature.GENERATE_BIOMES, MysticPlantFeature::placedFeature));
    public static final RegistryObject<Feature<?>> CUCUMBER_PLANT = RefinedPaletteModFeatures.register("cucumber_plant", CucumberPlantFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, CucumberPlantFeature.GENERATE_BIOMES, CucumberPlantFeature::placedFeature));
    public static final RegistryObject<Feature<?>> RICE_PLANT = RefinedPaletteModFeatures.register("rice_plant", RicePlantFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, RicePlantFeature.GENERATE_BIOMES, RicePlantFeature::placedFeature));
    public static final RegistryObject<Feature<?>> LETTUCE_PLANT = RefinedPaletteModFeatures.register("lettuce_plant", LettucePlantFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, LettucePlantFeature.GENERATE_BIOMES, LettucePlantFeature::placedFeature));
    public static final RegistryObject<Feature<?>> ONION_PLANT = RefinedPaletteModFeatures.register("onion_plant", OnionPlantFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, OnionPlantFeature.GENERATE_BIOMES, OnionPlantFeature::placedFeature));
    public static final RegistryObject<Feature<?>> TOMATO_PLANT = RefinedPaletteModFeatures.register("tomato_plant", TomatoPlantFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, TomatoPlantFeature.GENERATE_BIOMES, TomatoPlantFeature::placedFeature));
    public static final RegistryObject<Feature<?>> MAIZE_PLANT = RefinedPaletteModFeatures.register("maize_plant", MaizePlantFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, MaizePlantFeature.GENERATE_BIOMES, MaizePlantFeature::placedFeature));
    public static final RegistryObject<Feature<?>> BUBBLY_SAND = RefinedPaletteModFeatures.register("bubbly_sand", BubblySandFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, BubblySandFeature.GENERATE_BIOMES, BubblySandFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

