/*
 * Decompiled with CFR 0.152.
 */
package eu.gir.basics.init;

import eu.gir.basics.GIRMain;
import eu.gir.basics.blocks.BlockInvisibleLight;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class GIRInit {
    public static final CreativeTabs LIGHT_TAB = new CreativeTabs("invisiblelights"){

        public ItemStack func_78016_d() {
            return new ItemStack(INVISIBLE_LIGHTS_2);
        }
    };
    public static final Block INVISIBLE_LIGHTS_2 = new BlockInvisibleLight(2);
    public static final Block INVISIBLE_LIGHTS_3 = new BlockInvisibleLight(3);
    public static final Block INVISIBLE_LIGHTS_4 = new BlockInvisibleLight(4);
    public static final Block INVISIBLE_LIGHTS_5 = new BlockInvisibleLight(5);
    public static final Block INVISIBLE_LIGHTS_6 = new BlockInvisibleLight(6);
    public static final Block INVISIBLE_LIGHTS_7 = new BlockInvisibleLight(7);
    public static final Block INVISIBLE_LIGHTS_8 = new BlockInvisibleLight(8);
    public static final Block INVISIBLE_LIGHTS_9 = new BlockInvisibleLight(9);
    public static final Block INVISIBLE_LIGHTS_10 = new BlockInvisibleLight(10);
    public static final Block INVISIBLE_LIGHTS_11 = new BlockInvisibleLight(11);
    public static final Block INVISIBLE_LIGHTS_12 = new BlockInvisibleLight(12);
    public static final Block INVISIBLE_LIGHTS_13 = new BlockInvisibleLight(13);
    public static final Block INVISIBLE_LIGHTS_14 = new BlockInvisibleLight(14);
    public static final Block INVISIBLE_LIGHTS_15 = new BlockInvisibleLight(15);
    public static final ArrayList<Block> blocksToRegister = new ArrayList();
    public static final ArrayList<Item> itemsToRegister = new ArrayList();

    public static void init() {
        Field[] fields;
        for (Field field : fields = GIRInit.class.getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers) || !Modifier.isPublic(modifiers)) continue;
            String name = field.getName().toLowerCase().replace("_", "");
            try {
                Object obj = field.get(null);
                if (obj instanceof Block) {
                    Block block = (Block)obj;
                    block.setRegistryName(new ResourceLocation("invisiblelights", name));
                    block.func_149663_c(name);
                    blocksToRegister.add(block);
                    if (block instanceof ITileEntityProvider) {
                        ITileEntityProvider provider = (ITileEntityProvider)block;
                        try {
                            Class<?> tileclass = provider.func_149915_a(null, 0).getClass();
                            TileEntity.func_190560_a((String)tileclass.getSimpleName().toLowerCase(), tileclass);
                        }
                        catch (NullPointerException ex) {
                            GIRMain.LOG.trace("All tileentity provide need to call back a default entity if the world is null!", (Throwable)ex);
                        }
                    }
                }
                if (!(obj instanceof Item)) continue;
                Item item = (Item)obj;
                item.setRegistryName(new ResourceLocation("invisiblelights", name));
                item.func_77655_b(name);
                itemsToRegister.add(item);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void registerBlock(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        blocksToRegister.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }

    @SubscribeEvent
    public static void registerItem(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        blocksToRegister.forEach(block -> registry.register(new ItemBlock(block).setRegistryName(block.getRegistryName())));
        itemsToRegister.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }
}

