/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.util.math.MathHelper;
import net.valhelsia.valhelsia_core.client.Cosmetic;
import net.valhelsia.valhelsia_core.client.CosmeticsCategory;
import net.valhelsia.valhelsia_core.client.CosmeticsManager;
import net.valhelsia.valhelsia_core.client.screen.CosmeticsEntry;
import net.valhelsia.valhelsia_core.client.screen.CosmeticsListEntry;
import net.valhelsia.valhelsia_core.client.screen.CosmeticsWardrobeScreen;

public class CosmeticsList
extends AbstractOptionList<CosmeticsListEntry> {
    private static final int ENTRY_SPACING = 10;
    private static final int ENTRY_WIDTH = 88;
    private static final int ENTRY_HEIGHT = 100;
    private final List<CosmeticsEntry> entries = new ArrayList<CosmeticsEntry>();
    private final Minecraft minecraft;
    private CosmeticsWardrobeScreen screen;
    private final Button.IPressable onPress = button -> {
        CosmeticsEntry entry = (CosmeticsEntry)button;
        if (entry.isSelected()) {
            entry.setSelected(false);
            this.screen.getSelectedCosmetics().remove((Object)entry.getCategory());
        } else {
            entry.setSelected(true);
            this.entries.forEach(cosmeticsEntry -> {
                if (cosmeticsEntry != button) {
                    cosmeticsEntry.setSelected(false);
                }
            });
            this.screen.getSelectedCosmetics().put(entry.getCategory(), entry.getCosmetic());
        }
    };
    private final int rowCount;

    public CosmeticsList(Minecraft minecraft, CosmeticsWardrobeScreen screen, int width, int height, int y0, int y1) {
        super(minecraft, width, height, y0, y1, 110);
        this.minecraft = minecraft;
        this.screen = screen;
        this.rowCount = this.func_230949_c_() / 98;
        this.func_244605_b(false);
        this.func_244606_c(false);
    }

    public void update(CosmeticsCategory category) {
        this.func_230963_j_();
        CosmeticsManager cosmeticsManager = CosmeticsManager.getInstance();
        UUID uuid = this.minecraft.func_110432_I().func_148256_e().getId();
        List<Cosmetic> cosmetics = cosmeticsManager.getCosmeticsForPlayer(uuid, category);
        this.entries.clear();
        this.func_230932_a_(0.0);
        for (int i = 0; i < cosmetics.size(); ++i) {
            CosmeticsEntry leftEntry = new CosmeticsEntry(category, cosmetics.get(i), this.func_230968_n_(), 0, 88, 100, this.onPress, cosmetics.get(i).equals(this.screen.getSelectedCosmetics().get((Object)category)));
            CosmeticsEntry rightEntry = null;
            this.entries.add(leftEntry);
            if (i + 1 != cosmetics.size() && this.rowCount != 1) {
                rightEntry = new CosmeticsEntry(category, cosmetics.get(++i), this.func_230968_n_() + 88 + 10, 0, 88, 100, this.onPress, cosmetics.get(i).equals(this.screen.getSelectedCosmetics().get((Object)category)));
                this.entries.add(rightEntry);
            }
            this.func_230513_b_((AbstractList.AbstractListEntry)new CosmeticsListEntry(this, leftEntry, rightEntry));
        }
    }

    public int func_230949_c_() {
        return this.func_244736_r() - this.func_230968_n_();
    }

    public int func_230968_n_() {
        return (int)((float)this.field_230670_d_ / 5.73f);
    }

    public int func_244736_r() {
        return (int)((float)this.field_230670_d_ / 2.07f);
    }

    protected int func_230962_i_(int index) {
        return super.func_230962_i_(index);
    }

    protected int func_230952_d_() {
        return this.func_244736_r() + 10;
    }

    public void func_230430_a_(@Nonnull MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        double scale = this.getMinecraft().func_228018_at_().func_198100_s();
        RenderSystem.enableScissor((int)((int)((double)this.func_230968_n_() * scale)), (int)((int)((double)(this.field_230671_e_ - this.field_230673_j_) * scale)), (int)((int)((double)(this.func_230952_d_() + 6) * scale)), (int)((int)((double)(this.field_230671_e_ - (this.field_230671_e_ - this.field_230673_j_) - this.field_230672_i_) * scale)));
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        RenderSystem.disableScissor();
    }

    public boolean func_231044_a_(double pMouseX, double pMouseY, int pButton) {
        return super.func_231044_a_(pMouseX, pMouseY, pButton);
    }

    @Nullable
    public CosmeticsListEntry getEntryAtPosition(double mouseX, double mouseY) {
        int left = this.func_230968_n_();
        int right = this.func_244736_r();
        int i1 = MathHelper.func_76128_c((double)(mouseY - (double)this.field_230672_i_)) - this.field_230677_n_ + (int)this.func_230966_l_() - 4;
        int j1 = i1 / this.field_230669_c_;
        return mouseX < (double)this.func_230952_d_() && mouseX >= (double)left && mouseX <= (double)right && j1 >= 0 && i1 >= 0 && j1 < this.func_230965_k_() ? (CosmeticsListEntry)((Object)this.func_231039_at__().get(j1)) : null;
    }

    private Minecraft getMinecraft() {
        return this.minecraft;
    }
}

