/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.data;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.ILootFunctionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.functions.ExplosionDecay;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.RegistryObject;
import net.valhelsia.valhelsia_core.registry.RegistryManager;

public abstract class ValhelsiaBlockLootTables
implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
    public static final ILootCondition.IBuilder SILK_TOUCH = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))));
    public static final ILootCondition.IBuilder SHEARS = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)Tags.Items.SHEARS));
    private final List<Block> blocks = new ArrayList<Block>();
    private final Map<ResourceLocation, LootTable.Builder> lootTables = Maps.newHashMap();
    private final Set<RegistryObject<Block>> remainingBlocks;

    public ValhelsiaBlockLootTables(RegistryManager registryManager) {
        this.remainingBlocks = new HashSet<RegistryObject<Block>>(registryManager.getBlockHelper().getDeferredRegister().getEntries());
    }

    public abstract void addTables();

    public static Set<Item> immuneToExplosion() {
        return new HashSet<Item>();
    }

    @Override
    public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
        this.addTables();
        HashSet set = Sets.newHashSet();
        for (Block block : this.blocks) {
            LootTable.Builder loottable$builder;
            ResourceLocation resourcelocation = block.func_220068_i();
            if (resourcelocation == LootTables.field_186419_a || !set.add(resourcelocation) || (loottable$builder = this.lootTables.get(resourcelocation)) == null) continue;
            consumer.accept(resourcelocation, loottable$builder);
        }
    }

    public Set<RegistryObject<Block>> getRemainingBlocks() {
        return this.remainingBlocks;
    }

    public void forEach(Predicate<Block> predicate, Consumer<Block> consumer) {
        Iterator<RegistryObject<Block>> iterator = this.getRemainingBlocks().iterator();
        while (iterator.hasNext()) {
            Block block = (Block)iterator.next().get();
            if (!predicate.test(block)) continue;
            consumer.accept(block);
            iterator.remove();
        }
    }

    public void forEach(Consumer<Block> consumer) {
        Iterator<RegistryObject<Block>> iterator = this.getRemainingBlocks().iterator();
        while (iterator.hasNext()) {
            consumer.accept((Block)iterator.next().get());
            iterator.remove();
        }
    }

    @SafeVarargs
    public final <T extends Block> void take(Consumer<T> consumer, RegistryObject<? extends Block> ... blocks) {
        for (RegistryObject<? extends Block> block : blocks) {
            consumer.accept((Block)block.get());
            this.getRemainingBlocks().remove(block);
        }
    }

    protected static <T> T withExplosionDecay(IItemProvider item, ILootFunctionConsumer<T> function) {
        return (T)(!ValhelsiaBlockLootTables.immuneToExplosion().contains(item.func_199767_j()) ? function.func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()) : function.func_212862_c_());
    }

    protected static <T> T withSurvivesExplosion(IItemProvider item, ILootConditionConsumer<T> condition) {
        return (T)(!ValhelsiaBlockLootTables.immuneToExplosion().contains(item.func_199767_j()) ? condition.func_212840_b_(SurvivesExplosion.func_215968_b()) : condition.func_212862_c_());
    }

    protected static LootTable.Builder dropping(IItemProvider item) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)ValhelsiaBlockLootTables.withSurvivesExplosion(item, LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item))));
    }

    protected static <T extends Comparable<T> & IStringSerializable> LootTable.Builder droppingWhen(Block block, Property<T> property, T value) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)ValhelsiaBlockLootTables.withSurvivesExplosion((IItemProvider)block, LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_(property, value))))));
    }

    protected static LootTable.Builder onlyWithSilkTouch(IItemProvider item) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_(SILK_TOUCH).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item)));
    }

    protected static LootTable.Builder droppingAndFlowerPot(IItemProvider flower) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)ValhelsiaBlockLootTables.withSurvivesExplosion((IItemProvider)Blocks.field_150457_bL, LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Blocks.field_150457_bL)))).func_216040_a((LootPool.Builder)ValhelsiaBlockLootTables.withSurvivesExplosion(flower, LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)flower))));
    }

    protected static LootTable.Builder droppingWithFunction(Block block, Function<StandaloneLootEntry.Builder<?>, StandaloneLootEntry.Builder<?>> mapping) {
        return LootTable.func_216119_b().func_216040_a((LootPool.Builder)ValhelsiaBlockLootTables.withSurvivesExplosion((IItemProvider)block, LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)mapping.apply(ItemLootEntry.func_216168_a((IItemProvider)block)))));
    }

    protected static LootTable.Builder droppingSlab(Block slab) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ValhelsiaBlockLootTables.withExplosionDecay((IItemProvider)slab, ItemLootEntry.func_216168_a((IItemProvider)slab).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)slab).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_((Property)SlabBlock.field_196505_a, (Comparable)SlabType.DOUBLE)))))));
    }

    protected static LootTable.Builder onlyWithShears(IItemProvider item) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(SHEARS).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)item)));
    }

    protected static LootTable.Builder droppingSheared(Block sheared) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_(SHEARS).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)sheared)));
    }

    protected static LootTable.Builder droppingSheared(Block sheared, int count) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_(SHEARS).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)sheared).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)count)))));
    }

    protected static LootTable.Builder registerDoor(Block door) {
        return ValhelsiaBlockLootTables.droppingWhen(door, DoorBlock.field_176523_O, DoubleBlockHalf.LOWER);
    }

    protected static LootTable.Builder dropping(Block block, ILootCondition.IBuilder conditionBuilder, LootEntry.Builder<?> lootEntryBuilder) {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(conditionBuilder)).func_216080_a(lootEntryBuilder)));
    }

    protected static LootTable.Builder droppingWithSilkTouch(Block block, LootEntry.Builder<?> builder) {
        return ValhelsiaBlockLootTables.dropping(block, SILK_TOUCH, builder);
    }

    protected static LootTable.Builder droppingWithSilkTouch(Block block, IItemProvider noSilkTouch) {
        return ValhelsiaBlockLootTables.droppingWithSilkTouch(block, (LootEntry.Builder)ValhelsiaBlockLootTables.withSurvivesExplosion((IItemProvider)block, ItemLootEntry.func_216168_a((IItemProvider)noSilkTouch)));
    }

    protected Iterable<Block> getKnownBlocks() {
        return Registry.field_212618_g;
    }

    protected void registerFlowerPot(Block flowerPot) {
        this.registerLootTable(flowerPot, (Block pot) -> ValhelsiaBlockLootTables.droppingAndFlowerPot((IItemProvider)((FlowerPotBlock)pot).func_220276_d()));
    }

    protected void registerSilkTouch(Block blockIn, Block silkTouchDrop) {
        this.registerLootTable(blockIn, ValhelsiaBlockLootTables.onlyWithSilkTouch((IItemProvider)silkTouchDrop));
    }

    protected void registerDropping(Block blockIn, IItemProvider drop) {
        this.registerLootTable(blockIn, ValhelsiaBlockLootTables.dropping(drop));
    }

    protected void registerSilkTouch(Block blockIn) {
        this.registerSilkTouch(blockIn, blockIn);
    }

    protected void registerDropSelfLootTable(Block block) {
        this.registerDropping(block, (IItemProvider)block);
    }

    protected void registerLootTable(Block blockIn, Function<Block, LootTable.Builder> factory) {
        this.registerLootTable(blockIn, factory.apply(blockIn));
    }

    protected void registerLootTable(Block block, LootTable.Builder table) {
        this.blocks.add(block);
        this.lootTables.put(block.func_220068_i(), table);
    }

    public LootEntry.Builder<?> setCountFromIntegerProperty(Block block, StandaloneLootEntry.Builder<?> lootEntryBuilder, IntegerProperty intProperty) {
        intProperty.func_177700_c().forEach((? super T integer) -> lootEntryBuilder.func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)integer)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)intProperty, integer.intValue())))));
        return lootEntryBuilder;
    }
}

