/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.data;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;
import net.valhelsia.valhelsia_core.registry.RegistryManager;

public abstract class ValhelsiaBlockStateProvider
extends BlockStateProvider {
    private final Set<RegistryObject<Block>> remainingBlocks;

    public ValhelsiaBlockStateProvider(DataGenerator gen, RegistryManager registryManager, ExistingFileHelper exFileHelper) {
        super(gen, registryManager.getModId(), exFileHelper);
        this.remainingBlocks = new HashSet<RegistryObject<Block>>(registryManager.getBlockHelper().getDeferredRegister().getEntries());
    }

    public Set<RegistryObject<Block>> getRemainingBlocks() {
        return this.remainingBlocks;
    }

    public void forEach(Predicate<Block> predicate, Consumer<Block> consumer) {
        Iterator<RegistryObject<Block>> iterator = this.getRemainingBlocks().iterator();
        while (iterator.hasNext()) {
            Block block = (Block)iterator.next().get();
            if (!predicate.test(block)) continue;
            consumer.accept(block);
            iterator.remove();
        }
    }

    public void forEach(Consumer<Block> consumer) {
        Iterator<RegistryObject<Block>> iterator = this.getRemainingBlocks().iterator();
        while (iterator.hasNext()) {
            consumer.accept((Block)iterator.next().get());
            iterator.remove();
        }
    }

    @SafeVarargs
    public final <T extends Block> void take(Consumer<T> consumer, RegistryObject<? extends Block> ... blocks) {
        for (RegistryObject<? extends Block> block : blocks) {
            consumer.accept((Block)block.get());
            this.getRemainingBlocks().remove(block);
        }
    }

    public String getName(Block block) {
        return Objects.requireNonNull(block.getRegistryName()).func_110623_a();
    }

    public ModelFile.ExistingModelFile getExistingModel(ResourceLocation resourceLocation) {
        return this.models().getExistingFile(resourceLocation);
    }

    public void withExistingModel(Block block) {
        this.withExistingModel(block, false);
    }

    public void withExistingModel(Block block, boolean mcLoc) {
        this.simpleBlock(block, (ModelFile)this.getExistingModel(mcLoc ? this.mcLoc("block/" + this.getName(block)) : this.modLoc("block/" + this.getName(block))));
    }

    public void pressurePlateBlock(Block block, ResourceLocation texture) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.getName(block), this.mcLoc("block/pressure_plate_up"))).texture("texture", texture);
        ModelBuilder modelDown = ((BlockModelBuilder)this.models().withExistingParent(this.getName(block) + "_down", this.mcLoc("block/pressure_plate_down"))).texture("texture", texture);
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)PressurePlateBlock.field_176580_a, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)PressurePlateBlock.field_176580_a, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)modelDown).addModel();
    }

    public void buttonBlock(AbstractButtonBlock block, ResourceLocation texture) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block), this.mcLoc("block/button"))).texture("texture", texture);
        ModelBuilder modelPressed = ((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block) + "_pressed", this.mcLoc("block/button_pressed"))).texture("texture", texture);
        ((BlockModelBuilder)this.models().withExistingParent(this.getName((Block)block) + "_inventory", this.mcLoc("block/button_inventory"))).texture("texture", texture);
        this.getVariantBuilder((Block)block).forAllStates(arg_0 -> ValhelsiaBlockStateProvider.lambda$buttonBlock$0((ModelFile)model, (ModelFile)modelPressed, arg_0));
    }

    public void fenceBlock(FenceBlock block, ResourceLocation texture) {
        super.fenceBlock(block, texture);
        this.models().fenceInventory(this.getName((Block)block) + "_inventory", texture);
    }

    public void wallBlock(WallBlock block, ResourceLocation texture) {
        super.wallBlock(block, texture);
        this.models().wallInventory(this.getName((Block)block) + "_inventory", texture);
    }

    public void layerBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int height = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208129_ad) * 2;
            ModelFile model = height == 16 ? this.cubeAll(block) : ((BlockModelBuilder)this.models().withExistingParent(this.getName(block) + "_" + height, this.mcLoc("block/snow_height" + height))).texture("texture", this.modLoc("block/" + this.getName(block)));
            return ConfiguredModel.builder().modelFile(model).build();
        });
    }

    public void simpleFlowerPotBlock(Block block, ResourceLocation texture) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(this.getName(block), this.mcLoc("block/flower_pot_cross"))).texture("plant", texture);
        this.simpleBlock(block, (ModelFile)model);
    }

    private static /* synthetic */ ConfiguredModel[] lambda$buttonBlock$0(ModelFile model, ModelFile modelPressed, BlockState state) {
        Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        AttachFace face = (AttachFace)state.func_177229_b((Property)BlockStateProperties.field_208158_K);
        int rotationX = face == AttachFace.CEILING ? 180 : (face == AttachFace.WALL ? 90 : 0);
        int rotationY = (int)facing.func_176746_e().func_185119_l() + 90;
        return ConfiguredModel.builder().modelFile((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u) == false ? model : modelPressed).rotationX(rotationX).rotationY(face == AttachFace.CEILING ? rotationY - 180 : rotationY).uvLock(face == AttachFace.WALL).build();
    }
}

