/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.event;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.valhelsia.valhelsia_core.ValhelsiaCore;
import net.valhelsia.valhelsia_core.client.CosmeticsManager;
import net.valhelsia.valhelsia_core.network.NetworkHandler;
import net.valhelsia.valhelsia_core.network.UpdateCosmeticsPacket;
import net.valhelsia.valhelsia_core.registry.RegistryManager;
import net.valhelsia.valhelsia_core.util.AbstractConfigValidator;
import net.valhelsia.valhelsia_core.util.ConfigError;

@Mod.EventBusSubscriber
public class PlayerJoinWorldListener {
    @SubscribeEvent
    public static void onPlayerJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        ArrayList<ConfigError> errors = new ArrayList<ConfigError>();
        for (RegistryManager registryManager : ValhelsiaCore.REGISTRY_MANAGERS) {
            AbstractConfigValidator configValidator;
            if (registryManager.getConfigValidator() == null || (configValidator = registryManager.getConfigValidator()).getType() != AbstractConfigValidator.Type.WORLD_LOAD) continue;
            configValidator.validate();
            configValidator.getErrors().forEach(configError -> configError.setModID(registryManager.getModId()));
            errors.addAll(configValidator.getErrors());
        }
        if (!errors.isEmpty()) {
            errors.forEach(configError -> {
                player.func_145747_a((ITextComponent)new StringTextComponent(configError.getModID()).func_240699_a_(TextFormatting.UNDERLINE), player.func_110124_au());
                player.func_145747_a((ITextComponent)new TranslationTextComponent("gui.valhelsia_core.config.error").func_240702_b_(": " + configError.getPath()), player.func_110124_au());
                player.func_145747_a((ITextComponent)configError.getErrorMessage(), player.func_110124_au());
            });
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        PlayerEntity player = event.getPlayer();
        UUID uuid = player.func_110124_au();
        if (event.getTarget() instanceof PlayerEntity) {
            NetworkHandler.sendTo((PlayerEntity)event.getTarget(), new UpdateCosmeticsPacket(uuid, CosmeticsManager.getInstance().getActiveCosmeticsForPlayer(uuid)));
        }
    }
}

