/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.gui.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.util.ResourceLocation;
import net.valhelsia.valhelsia_core.gui.element.GuiElement;
import net.valhelsia.valhelsia_core.util.TextureInfo;

public abstract class ButtonElement
extends GuiElement {
    private int startX;
    private int startY;
    private final int blitOffset;
    private final ResourceLocation resourceLocation;
    private boolean activated = false;
    private final int textureSizeX;
    private final int textureSizeY;
    private final IPressable onPress;

    public ButtonElement(int posX, int posY, int blitOffset, int startX, int startY, int sizeX, int sizeY, ResourceLocation resourceLocation, IPressable onPress) {
        super(posX, posY, sizeX, sizeY);
        this.startX = startX;
        this.startY = startY;
        this.blitOffset = blitOffset;
        this.resourceLocation = resourceLocation;
        this.textureSizeX = 256;
        this.textureSizeY = 256;
        this.onPress = onPress;
    }

    public ButtonElement(int posX, int posY, int blitOffset, int startX, int startY, int sizeX, int sizeY, TextureInfo textureInfo, IPressable onPress) {
        super(posX, posY, sizeX, sizeY);
        this.startX = startX;
        this.startY = startY;
        this.blitOffset = blitOffset;
        this.resourceLocation = textureInfo.getResourceLocation();
        this.textureSizeX = textureInfo.getTextureSizeX();
        this.textureSizeY = textureInfo.getTextureSizeY();
        this.onPress = onPress;
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.bindTexture(this.resourceLocation);
        this.blit(matrixStack, this.blitOffset, this.startX, this.startY, this.getSizeX(), this.getSizeY(), this.textureSizeX, this.textureSizeY);
    }

    @Override
    public boolean onClicked(double mouseX, double mouseY, int button) {
        return this.onPress.onPress(this);
    }

    public ButtonElement setActivated(boolean activated) {
        this.activated = activated;
        return this;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public int getStartX() {
        return this.startX;
    }

    public void setStartX(int startX) {
        this.startX = startX;
    }

    public int getStartY() {
        return this.startY;
    }

    public void setStartY(int startY) {
        this.startY = startY;
    }

    public int getBlitOffset() {
        return this.blitOffset;
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public int getTextureSizeX() {
        return this.textureSizeX;
    }

    public int getTextureSizeY() {
        return this.textureSizeY;
    }

    public static interface IPressable {
        public boolean onPress(ButtonElement var1);
    }
}

