/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;

public class VoxelShapeHelper {
    public static VoxelShape combineAll(Collection<VoxelShape> shapes) {
        VoxelShape result = VoxelShapes.func_197880_a();
        for (VoxelShape shape : shapes) {
            result = VoxelShapes.func_197878_a((VoxelShape)result, (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return result.func_197753_c();
    }

    public static VoxelShape combineAll(VoxelShape ... shapes) {
        VoxelShape result = VoxelShapes.func_197880_a();
        for (VoxelShape shape : shapes) {
            result = VoxelShapes.func_197878_a((VoxelShape)result, (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        return result.func_197753_c();
    }

    public static Map<Direction, VoxelShape> getRotatedShapes(VoxelShape shape) {
        HashMap<Direction, VoxelShape> map = new HashMap<Direction, VoxelShape>();
        for (Direction direction : Direction.values()) {
            RotationAmount rotationAmount = RotationAmount.getRotationAmountFromDirection(direction);
            if (rotationAmount == null) continue;
            map.put(direction, VoxelShapeHelper.rotateShape(shape, rotationAmount));
        }
        return map;
    }

    public static VoxelShape rotateShape(VoxelShape shape, RotationAmount rotationAmount) {
        if (shape.func_197766_b() || rotationAmount == RotationAmount.ZERO) {
            return shape;
        }
        HashSet rotatedShapes = new HashSet();
        shape.func_197755_b((x1, y1, z1, x2, y2, z2) -> {
            x1 = x1 * 16.0 - 8.0;
            x2 = x2 * 16.0 - 8.0;
            z1 = z1 * 16.0 - 8.0;
            z2 = z2 * 16.0 - 8.0;
            if (rotationAmount == RotationAmount.NINETY) {
                rotatedShapes.add(Block.func_208617_a((double)(8.0 - z1), (double)(y1 * 16.0), (double)(8.0 + x1), (double)(8.0 - z2), (double)(y2 * 16.0), (double)(8.0 + x2)));
            } else if (rotationAmount == RotationAmount.HUNDRED_EIGHTY) {
                rotatedShapes.add(Block.func_208617_a((double)(8.0 - x1), (double)(y1 * 16.0), (double)(8.0 - z1), (double)(8.0 - x2), (double)(y2 * 16.0), (double)(8.0 - z2)));
            } else if (rotationAmount == RotationAmount.TWO_HUNDRED_SEVENTY) {
                rotatedShapes.add(Block.func_208617_a((double)(8.0 + z1), (double)(y1 * 16.0), (double)(8.0 - x1), (double)(8.0 + z2), (double)(y2 * 16.0), (double)(8.0 - x2)));
            }
        });
        return (VoxelShape)rotatedShapes.stream().reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    }

    public static VoxelShape rotateShapeDirection(VoxelShape shape, Direction direction) {
        return VoxelShapeHelper.rotateShape(shape, RotationAmount.getRotationAmountFromDirection(direction));
    }

    public static VoxelShape rotateShapeAxis(VoxelShape shape, Direction.Axis axis) {
        HashSet rotatedShapes = new HashSet();
        shape.func_197755_b((x1, y1, z1, x2, y2, z2) -> {
            if (axis == Direction.Axis.X) {
                rotatedShapes.add(Block.func_208617_a((double)(y1 * 16.0), (double)(x1 * 16.0), (double)(z1 * 16.0), (double)(y2 * 16.0), (double)(x2 * 16.0), (double)(z2 * 16.0)));
            } else if (axis == Direction.Axis.Z) {
                rotatedShapes.add(VoxelShapeHelper.rotateShape(Block.func_208617_a((double)(x1 * 16.0), (double)(z1 * 16.0), (double)(y1 * 16.0), (double)(x2 * 16.0), (double)(z2 * 16.0), (double)(y2 * 16.0)), RotationAmount.HUNDRED_EIGHTY));
            } else {
                rotatedShapes.add(Block.func_208617_a((double)(x1 * 16.0), (double)(y1 * 16.0), (double)(z1 * 16.0), (double)(x2 * 16.0), (double)(y2 * 16.0), (double)(z2 * 16.0)));
            }
        });
        return (VoxelShape)rotatedShapes.stream().reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    }

    public static VoxelShape add(double x1, double y1, double z1, double x2, double y2, double z2, VoxelShape ... shapes) {
        HashSet result = new HashSet();
        for (VoxelShape shape : shapes) {
            shape.func_197755_b((x, y, z, x3, y3, z3) -> result.add(Block.func_208617_a((double)((x *= 16.0) + x1), (double)((y *= 16.0) + y1), (double)((z *= 16.0) + z1), (double)((x3 *= 16.0) + x2), (double)((y3 *= 16.0) + y2), (double)((z3 *= 16.0) + z2))));
        }
        return (VoxelShape)result.stream().reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    }

    public static enum RotationAmount {
        ZERO,
        NINETY,
        HUNDRED_EIGHTY,
        TWO_HUNDRED_SEVENTY;


        public static RotationAmount getRotationAmountFromDirection(Direction direction) {
            switch (direction) {
                case NORTH: {
                    return ZERO;
                }
                case EAST: {
                    return NINETY;
                }
                case SOUTH: {
                    return HUNDRED_EIGHTY;
                }
                case WEST: {
                    return TWO_HUNDRED_SEVENTY;
                }
            }
            return null;
        }
    }
}

