/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.loot.conditions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Calendar;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.valhelsia.valhelsia_core.init.ValhelsiaLootConditions;

public class DateCondition
implements ILootCondition {
    private final int month;
    private final int startDay;
    private final int endDay;

    public DateCondition(int month, int startDay, int endDay) {
        this.month = month;
        this.startDay = startDay;
        this.endDay = endDay;
    }

    public static ILootCondition.IBuilder builder(int month, int startDay, int endDay) {
        return () -> new DateCondition(month, startDay, endDay);
    }

    @Nonnull
    public LootConditionType func_230419_b_() {
        return ValhelsiaLootConditions.DATE;
    }

    @Nonnull
    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of();
    }

    public boolean test(LootContext lootContext) {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == this.month && calendar.get(5) >= this.startDay && calendar.get(5) <= this.endDay;
    }

    public static class Serializer
    implements ILootSerializer<DateCondition> {
        public void serialize(@Nonnull JsonObject jsonObject, DateCondition instance, @Nonnull JsonSerializationContext context) {
            jsonObject.addProperty("month", (Number)instance.month);
            jsonObject.addProperty("start_day", (Number)instance.startDay);
            jsonObject.addProperty("end_day", (Number)instance.endDay);
        }

        @Nonnull
        public DateCondition deserialize(@Nonnull JsonObject jsonObject, @Nonnull JsonDeserializationContext context) {
            return new DateCondition(JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"month"), JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"start_day"), JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"end_day"));
        }
    }
}

