/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.valhelsia.valhelsia_core.client.CosmeticsManager;
import net.valhelsia.valhelsia_core.network.NetworkHandler;
import net.valhelsia.valhelsia_core.network.UpdateCosmeticsPacket;

public class UploadCosmeticsPacket {
    private final UUID uuid;
    private final CompoundNBT activeCosmetics;

    public UploadCosmeticsPacket(UUID uuid, CompoundNBT activeCosmetics) {
        this.uuid = uuid;
        this.activeCosmetics = activeCosmetics;
    }

    public static void encode(UploadCosmeticsPacket packet, PacketBuffer buffer) {
        buffer.func_179252_a(packet.uuid);
        buffer.func_150786_a(packet.activeCosmetics);
    }

    public static UploadCosmeticsPacket decode(PacketBuffer buffer) {
        return new UploadCosmeticsPacket(buffer.func_179253_g(), buffer.func_150793_b());
    }

    public static void consume(UploadCosmeticsPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                CosmeticsManager cosmeticsManager = CosmeticsManager.getInstance();
                cosmeticsManager.setActiveCosmeticsForPlayer(packet.uuid, packet.activeCosmetics);
                cosmeticsManager.getLoadedPlayers().add(packet.uuid);
                NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> ((NetworkEvent.Context)context).getSender()), (Object)new UpdateCosmeticsPacket(packet.uuid, packet.activeCosmetics));
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

