/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.util;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;

public class ItemStackUtils {
    public static void shrinkStack(@Nullable PlayerEntity player, ItemStack stack) {
        ItemStackUtils.shrinkStack(player, stack, 1);
    }

    public static void shrinkStack(@Nullable PlayerEntity player, ItemStack stack, int count) {
        if (player == null || !player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(count);
        }
    }

    public static ItemStack transferEnchantments(ItemStack oldStack, ItemStack newStack) {
        if (!EnchantmentHelper.func_82781_a((ItemStack)oldStack).isEmpty()) {
            EnchantmentHelper.func_82781_a((ItemStack)oldStack).forEach((arg_0, arg_1) -> ((ItemStack)newStack).func_77966_a(arg_0, arg_1));
        }
        return newStack;
    }

    public static boolean hasStackEnchantment(ItemStack stack, Enchantment enchantment) {
        return ItemStackUtils.hasStackEnchantment(stack, Collections.singletonList(enchantment));
    }

    public static boolean hasStackEnchantment(ItemStack stack, List<Enchantment> enchantments) {
        for (Enchantment itemEnchantment : EnchantmentHelper.func_82781_a((ItemStack)stack).keySet()) {
            for (Enchantment enchantment : enchantments) {
                if (itemEnchantment != enchantment) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack removeEnchantments(ItemStack stack) {
        ItemStack copy = stack.func_77946_l();
        copy.func_196083_e("Enchantments");
        copy.func_196083_e("StoredEnchantments");
        Map<Enchantment, Integer> map = EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(entry -> ((Enchantment)entry.getKey()).func_190936_d()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        EnchantmentHelper.func_82782_a(map, (ItemStack)copy);
        copy.func_82841_c(0);
        if (copy.func_77973_b() == Items.field_151134_bR && map.size() == 0) {
            copy = new ItemStack((IItemProvider)Items.field_151122_aG);
            if (stack.func_82837_s()) {
                copy.func_200302_a(stack.func_200301_q());
            }
        }
        for (int i = 0; i < map.size(); ++i) {
            copy.func_82841_c(RepairContainer.func_216977_d((int)copy.func_82838_A()));
        }
        return copy;
    }

    public static ItemStack getFilledMap(World world, BlockPos playerPos, Structure<?> structure, MapDecoration.Type decorationType) {
        if (!(world instanceof ServerWorld)) {
            return null;
        }
        ServerWorld serverWorld = (ServerWorld)world;
        BlockPos pos = serverWorld.func_241117_a_(structure, playerPos, 100, true);
        if (pos == null) {
            return null;
        }
        ItemStack stack = FilledMapItem.func_195952_a((World)serverWorld, (int)pos.func_177958_n(), (int)pos.func_177952_p(), (byte)2, (boolean)true, (boolean)true);
        FilledMapItem.func_226642_a_((ServerWorld)serverWorld, (ItemStack)stack);
        MapData.func_191094_a((ItemStack)stack, (BlockPos)pos, (String)"+", (MapDecoration.Type)decorationType);
        return stack.func_200302_a((ITextComponent)new TranslationTextComponent("filled_map." + structure.func_143025_a().toLowerCase(Locale.ROOT)));
    }
}

