/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.block;

import com.google.common.collect.ImmutableMap;
import com.stal111.valhelsia_structures.block.PostBlock;
import com.stal111.valhelsia_structures.block.properties.ModBlockStateProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.valhelsia.valhelsia_core.helper.VoxelShapeHelper;

public class CutPostBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty ATTACHED = ModBlockStateProperties.ATTACHED;
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    public static final IntegerProperty PARTS = ModBlockStateProperties.PARTS_1_4;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final Map<Direction, List<VoxelShape>> SHAPES = new ImmutableMap.Builder().put((Object)Direction.UP, Arrays.asList(Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0))).put((Object)Direction.DOWN, Arrays.asList(Block.func_208617_a((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.func_208617_a((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.func_208617_a((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0))).put((Object)Direction.SOUTH, Arrays.asList(Block.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)4.0), Block.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)8.0), Block.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)12.0))).put((Object)Direction.NORTH, Arrays.asList(Block.func_208617_a((double)3.0, (double)3.0, (double)12.0, (double)13.0, (double)13.0, (double)16.0), Block.func_208617_a((double)3.0, (double)3.0, (double)8.0, (double)13.0, (double)13.0, (double)16.0), Block.func_208617_a((double)3.0, (double)3.0, (double)4.0, (double)13.0, (double)13.0, (double)16.0))).put((Object)Direction.EAST, Arrays.asList(Block.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)4.0, (double)13.0, (double)13.0), Block.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)8.0, (double)13.0, (double)13.0), Block.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)12.0, (double)13.0, (double)13.0))).put((Object)Direction.WEST, Arrays.asList(Block.func_208617_a((double)12.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), Block.func_208617_a((double)8.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), Block.func_208617_a((double)4.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0))).build();

    public CutPostBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)PARTS, (Comparable)Integer.valueOf(1))).func_206870_a((Property)FACING, (Comparable)Direction.UP)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        int parts = (Integer)state.func_177229_b((Property)PARTS);
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        VoxelShape shape = parts == 4 ? PostBlock.SHAPES.get(facing.func_176740_k()) : SHAPES.get(facing).get(parts - 1);
        return (Boolean)state.func_177229_b((Property)ATTACHED) != false ? VoxelShapeHelper.add((double)0.0, (double)-3.0, (double)0.0, (double)0.0, (double)-3.0, (double)0.0, (VoxelShape[])new VoxelShape[]{shape}) : shape;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (this.shouldAttach(world, pos)) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ATTACHED, (Comparable)Boolean.valueOf(true)), 2);
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (state.func_203425_a((Block)this)) {
            return (BlockState)state.func_206870_a((Property)PARTS, (Comparable)Integer.valueOf(Math.min(4, (Integer)state.func_177229_b((Property)PARTS) + 1)));
        }
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = fluidstate.func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)Objects.requireNonNull(super.func_196258_a(context)).func_206870_a((Property)FACING, (Comparable)context.func_196000_l())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return useContext.func_195996_i().func_77973_b() == this.func_199767_j() && (Integer)state.func_177229_b((Property)PARTS) < 4 || super.func_196253_a(state, useContext);
    }

    private boolean shouldAttach(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)world, pos.func_177977_b(), Direction.UP) && ((Direction)world.func_180495_p(pos).func_177229_b((Property)FACING)).func_176740_k() != Direction.Axis.Y;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)mirror.func_185803_b((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ATTACHED, PARTS, FACING, WATERLOGGED});
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return false;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

