/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.block;

import com.google.common.collect.ImmutableMap;
import com.stal111.valhelsia_structures.block.properties.ModBlockStateProperties;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.valhelsia.valhelsia_core.helper.VoxelShapeHelper;

public class PostBlock
extends RotatedPillarBlock
implements IWaterLoggable {
    public static final BooleanProperty ATTACHED = ModBlockStateProperties.ATTACHED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private final Supplier<? extends Block> logBlock;
    public static final Map<Direction.Axis, VoxelShape> SHAPES = ImmutableMap.of((Object)Direction.Axis.Y, (Object)Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (Object)Direction.Axis.Z, (Object)Block.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0), (Object)Direction.Axis.X, (Object)Block.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));

    public PostBlock(Supplier<? extends Block> logBlock) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)((AbstractBlock)logBlock.get())).func_226896_b_());
        this.logBlock = logBlock;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public PostBlock(ResourceLocation logBlock, AbstractBlock.Properties properties) {
        super(properties.func_226896_b_());
        this.logBlock = () -> (Block)ForgeRegistries.BLOCKS.getValue(logBlock);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)ATTACHED) != false ? VoxelShapeHelper.add((double)0.0, (double)-3.0, (double)0.0, (double)0.0, (double)-3.0, (double)0.0, (VoxelShape[])new VoxelShape[]{SHAPES.get(state.func_177229_b((Property)field_176298_M))}) : SHAPES.get(state.func_177229_b((Property)field_176298_M));
    }

    public Block getLogBlock() {
        return this.logBlock.get();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (this.shouldAttach(world, pos)) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)ATTACHED, (Comparable)Boolean.valueOf(true)), 2);
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = fluidstate.func_206886_c() == Fluids.field_204546_a;
        return (BlockState)Objects.requireNonNull(super.func_196258_a(context)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    private boolean shouldAttach(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)world, pos.func_177977_b(), Direction.UP) && world.func_180495_p(pos).func_177229_b((Property)field_176298_M) != Direction.Axis.Y;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ATTACHED, field_176298_M, WATERLOGGED});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

