/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.registries.ForgeRegistries;

public class StructureUtils {
    public static Direction getRandomDir(Random rand) {
        return Direction.func_176731_b((int)rand.nextInt(4));
    }

    public static int getLowestHeight(IWorld world, int x, int z, int xSize, int zSize) {
        int h0 = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x, z);
        int h1 = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x + xSize, z);
        int h2 = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x, z + zSize);
        int h3 = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x + xSize, z + zSize);
        return Math.min(Math.min(h0, h1), Math.min(h2, h3));
    }

    public static BlockPos getSurfaceStructurePosition(@Nonnull ChunkGenerator generator, int size, Rotation rotation, int chunkX, int chunkZ) {
        int xOffset = size * 16;
        int zOffset = size * 16;
        int x = chunkX << 4;
        int z = chunkZ << 4;
        return new BlockPos(x + xOffset / 2, 0, z + zOffset / 2);
    }

    public static boolean checkForOtherStructures(Structure<?> structure, ChunkGenerator generator, long seed, SharedSeedRandom rand, int chunkX, int chunkZ, List<Structure<?>> structures) {
        for (Structure<?> structure1 : structures) {
            StructureSeparationSettings separationSettings = generator.func_235957_b_().func_236197_a_(structure1);
            if (separationSettings == null || structure == structure1) continue;
            for (int x = chunkX - 5; x <= chunkX + 5; ++x) {
                for (int z = chunkZ - 5; z <= chunkZ + 5; ++z) {
                    ChunkPos structurePos = structure1.func_236392_a_(separationSettings, seed, rand, x, z);
                    if (x != structurePos.field_77276_a || z != structurePos.field_77275_b) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static List<String> getAllBiomesForCategory(Biome.Category ... categories) {
        ArrayList<String> biomes = new ArrayList<String>();
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            for (Biome.Category category : categories) {
                if (biome.func_201856_r() != category) continue;
                biomes.add(Objects.requireNonNull(biome.getRegistryName()).toString());
            }
        }
        return biomes;
    }
}

