/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.gui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.valhelsia.valhelsia_core.client.cosmetics.Cosmetic;
import net.valhelsia.valhelsia_core.client.cosmetics.CosmeticsCategory;
import net.valhelsia.valhelsia_core.client.gui.component.SelectableComponent;
import net.valhelsia.valhelsia_core.client.gui.screen.CosmeticsWardrobeScreen;
import net.valhelsia.valhelsia_core.client.util.TextureDownloader;

public class CosmeticsEntry
extends Button
implements SelectableComponent {
    public static final int BG_COLOR = FastColor.ARGB32.m_13660_((int)255, (int)5, (int)17, (int)31);
    private final CosmeticsCategory category;
    private final Cosmetic cosmetic;
    private ResourceLocation previewTexture = null;
    private boolean selected;

    public CosmeticsEntry(CosmeticsCategory category, Cosmetic cosmetic, int x, int y, int width, int height, Button.OnPress onPress, boolean selected) {
        super(x, y, width, height, (Component)new TranslatableComponent("cosmetic.valhelsia_core." + cosmetic.getName()), onPress);
        this.category = category;
        this.cosmetic = cosmetic;
        this.selected = selected;
        try {
            TextureDownloader.downloadTexture(new URL("https://static.valhelsia.net/cosmetics/preview/" + cosmetic.getName() + ".png"), "cosmetics/preview/", texture -> {
                this.previewTexture = texture;
            });
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void m_6303_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        GuiComponent.m_93172_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)BG_COLOR);
        if (this.isSelected()) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)CosmeticsWardrobeScreen.TEXTURE);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)92.0f, (int)this.f_93618_, (int)this.f_93619_, (int)256, (int)256);
        }
        if (this.previewTexture != null) {
            DynamicTexture texture = (DynamicTexture)Minecraft.m_91087_().m_91097_().m_174786_(this.previewTexture, (AbstractTexture)MissingTextureAtlasSprite.m_118080_());
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.previewTexture);
            poseStack.m_85836_();
            GuiComponent.m_93160_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (int)this.f_93618_, (int)this.f_93619_, (float)0.0f, (float)0.0f, (int)texture.m_117991_().m_84982_(), (int)texture.m_117991_().m_85084_(), (int)texture.m_117991_().m_84982_(), (int)texture.m_117991_().m_85084_());
            poseStack.m_85849_();
        }
    }

    public CosmeticsCategory getCategory() {
        return this.category;
    }

    public Cosmetic getCosmetic() {
        return this.cosmetic;
    }
}

