/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.util;

import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.FilenameUtils;

public class TextureDownloader {
    private static final Map<String, ResourceLocation> LOADED_TEXTURES = new HashMap<String, ResourceLocation>();

    public static void downloadTexture(URL url, String path, @Nullable TextureAvailableCallback textureAvailableCallback) {
        TextureDownloader.downloadTexture(url, path, null, textureAvailableCallback);
    }

    public static void downloadTexture(URL url, String path, @Nullable String identifier, @Nullable TextureAvailableCallback textureAvailableCallback) {
        CompletableFuture.runAsync(() -> RenderSystem.m_69879_(() -> {
            String s = Hashing.sha1().hashUnencodedChars((CharSequence)FilenameUtils.getBaseName((String)url.toString())).toString();
            ResourceLocation resourceLocation = new ResourceLocation("valhelsia_core", path + s);
            TextureManager textureManager = Minecraft.m_91087_().m_91097_();
            AbstractTexture texture = textureManager.m_174786_(resourceLocation, (AbstractTexture)MissingTextureAtlasSprite.m_118080_());
            if (texture == MissingTextureAtlasSprite.m_118080_()) {
                try {
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
                    NativeImage image = NativeImage.m_85058_((InputStream)connection.getInputStream());
                    textureManager.m_118495_(resourceLocation, (AbstractTexture)new DynamicTexture(image));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (identifier != null) {
                LOADED_TEXTURES.put(identifier, resourceLocation);
            }
            if (textureAvailableCallback != null) {
                textureAvailableCallback.onTextureAvailable(resourceLocation);
            }
        }), Util.m_137578_());
    }

    public static ResourceLocation getTexture(String identifier) {
        return LOADED_TEXTURES.getOrDefault(identifier, null);
    }

    public static interface TextureAvailableCallback {
        public void onTextureAvailable(ResourceLocation var1);
    }
}

