/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.common.capability.counter;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.valhelsia.valhelsia_core.common.capability.counter.CounterCapability;
import net.valhelsia.valhelsia_core.common.capability.counter.CounterImpl;
import net.valhelsia.valhelsia_core.common.capability.counter.SimpleCounter;

public class CounterProvider
implements ICapabilityProvider,
ICapabilitySerializable<CompoundTag> {
    @CapabilityInject(value=CounterCapability.class)
    public static Capability<CounterCapability> CAPABILITY = null;
    private final CounterCapability instance = new CounterImpl();

    public CounterProvider(List<SimpleCounter> counters) {
        for (SimpleCounter counter : counters) {
            this.instance.addCounter(counter);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == CAPABILITY ? LazyOptional.of(() -> this.instance) : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        for (SimpleCounter counter : this.instance.getCounters()) {
            compound.m_128365_(counter.getName().toString(), (Tag)counter.save(new CompoundTag()));
        }
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (String name : nbt.m_128431_()) {
            this.instance.removeCounter(this.instance.getCounter(new ResourceLocation(name)));
            SimpleCounter counter = new SimpleCounter(new ResourceLocation(name));
            counter.load(nbt.m_128469_(name));
            this.instance.addCounter(counter);
        }
    }
}

