/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.common.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelShapeHelper {
    public static VoxelShape combineAll(Collection<VoxelShape> shapes) {
        VoxelShape result = Shapes.m_83040_();
        for (VoxelShape shape : shapes) {
            result = Shapes.m_83113_((VoxelShape)result, (VoxelShape)shape, (BooleanOp)BooleanOp.f_82695_);
        }
        return result.m_83296_();
    }

    public static VoxelShape combineAll(VoxelShape ... shapes) {
        VoxelShape result = Shapes.m_83040_();
        for (VoxelShape shape : shapes) {
            result = Shapes.m_83113_((VoxelShape)result, (VoxelShape)shape, (BooleanOp)BooleanOp.f_82695_);
        }
        return result.m_83296_();
    }

    public static Map<Direction, VoxelShape> getRotatedShapes(VoxelShape shape) {
        return Arrays.stream(Direction.values()).collect(Collectors.toMap(Function.identity(), direction -> VoxelShapeHelper.rotateShape(shape, direction)));
    }

    public static VoxelShape rotateShape(VoxelShape shape, Direction direction) {
        double[] adjustedValues = VoxelShapeHelper.adjustValues(direction, shape.m_83288_(Direction.Axis.X), shape.m_83288_(Direction.Axis.Z), shape.m_83297_(Direction.Axis.X), shape.m_83297_(Direction.Axis.Z));
        return Shapes.m_83048_((double)adjustedValues[0], (double)shape.m_83288_(Direction.Axis.Y), (double)adjustedValues[1], (double)adjustedValues[2], (double)shape.m_83297_(Direction.Axis.Y), (double)adjustedValues[3]);
    }

    private static double[] adjustValues(Direction direction, double minX, double minZ, double maxX, double maxZ) {
        switch (direction) {
            case WEST: {
                double temp_minX = minX;
                minX = 1.0 - maxX;
                double temp_minZ = minZ;
                minZ = 1.0 - maxZ;
                maxX = 1.0 - temp_minX;
                maxZ = 1.0 - temp_minZ;
                break;
            }
            case NORTH: {
                double temp_minX = minX;
                minX = minZ;
                minZ = 1.0 - maxX;
                maxX = maxZ;
                maxZ = 1.0 - temp_minX;
                break;
            }
            case SOUTH: {
                double temp_minX = minX;
                minX = 1.0 - maxZ;
                double temp_minZ = minZ;
                minZ = temp_minX;
                double temp_maxX = maxX;
                maxX = 1.0 - temp_minZ;
                maxZ = temp_maxX;
            }
        }
        return new double[]{minX, minZ, maxX, maxZ};
    }

    public static VoxelShape rotate(VoxelShape shape, Direction.Axis axis) {
        if (axis == Direction.Axis.Y) {
            return shape;
        }
        HashSet rotatedShapes = new HashSet();
        shape.m_83286_((x1, y1, z1, x2, y2, z2) -> {
            y1 *= 16.0;
            y2 *= 16.0;
            x1 *= 16.0;
            x2 *= 16.0;
            z1 *= 16.0;
            z2 *= 16.0;
            if (axis == Direction.Axis.X) {
                rotatedShapes.add(Block.m_49796_((double)y1, (double)x1, (double)z1, (double)y2, (double)x2, (double)z2));
            } else {
                rotatedShapes.add(Block.m_49796_((double)x1, (double)z1, (double)y1, (double)x2, (double)z2, (double)y2));
            }
        });
        return (VoxelShape)rotatedShapes.stream().reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    }

    public static VoxelShape add(double x1, double y1, double z1, double x2, double y2, double z2, VoxelShape ... shapes) {
        HashSet result = new HashSet();
        for (VoxelShape shape : shapes) {
            shape.m_83286_((x, y, z, x3, y3, z3) -> result.add(Block.m_49796_((double)((x *= 16.0) + x1), (double)((y *= 16.0) + y1), (double)((z *= 16.0) + z1), (double)((x3 *= 16.0) + x2), (double)((y3 *= 16.0) + y2), (double)((z3 *= 16.0) + z2))));
        }
        return result.stream().reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).orElse(Shapes.m_83040_());
    }

    public static enum RotationAmount {
        ZERO,
        NINETY,
        HUNDRED_EIGHTY,
        TWO_HUNDRED_SEVENTY;


        public static RotationAmount getRotationAmountFromDirection(Direction direction) {
            return switch (direction) {
                case Direction.NORTH -> ZERO;
                case Direction.EAST -> NINETY;
                case Direction.SOUTH -> HUNDRED_EIGHTY;
                case Direction.WEST -> TWO_HUNDRED_SEVENTY;
                default -> null;
            };
        }
    }
}

