/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.common.loot.conditions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.valhelsia.valhelsia_core.core.init.ValhelsiaLootConditions;

public record EntityTagCondition(Tag<EntityType<?>> tag) implements LootItemCondition
{
    public static LootItemCondition.Builder builder(Tag<EntityType<?>> tag) {
        return () -> new EntityTagCondition(tag);
    }

    @Nonnull
    public LootItemConditionType m_7940_() {
        return ValhelsiaLootConditions.ENTITY_TAG;
    }

    @Nonnull
    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81455_);
    }

    public boolean test(LootContext lootContext) {
        if (!lootContext.m_78936_(LootContextParams.f_81455_)) {
            return false;
        }
        Entity entity = (Entity)lootContext.m_165124_(LootContextParams.f_81455_);
        return this.tag.m_8110_((Object)entity.m_6095_());
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<EntityTagCondition> {
        public void serialize(@Nonnull JsonObject jsonObject, EntityTagCondition instance, @Nonnull JsonSerializationContext context) {
            jsonObject.addProperty("tag", SerializationTags.m_13199_().m_144454_(Registry.f_122903_, instance.tag, () -> new IllegalStateException("Unknown entity type tag")).toString());
        }

        @Nonnull
        public EntityTagCondition deserialize(@Nonnull JsonObject jsonObject, @Nonnull JsonDeserializationContext context) {
            ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"tag"));
            Tag tag = SerializationTags.m_13199_().m_144458_(Registry.f_122903_, resourceLocation, id -> new JsonSyntaxException("Unknown entity type tag '" + id + "'"));
            return new EntityTagCondition(tag);
        }
    }
}

