/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.block;

import com.google.common.collect.ImmutableMap;
import com.stal111.valhelsia_structures.common.block.PostBlock;
import com.stal111.valhelsia_structures.common.block.properties.ModBlockStateProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.valhelsia.valhelsia_core.common.helper.VoxelShapeHelper;

public class CutPostBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty ATTACHED = ModBlockStateProperties.ATTACHED;
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final IntegerProperty PARTS = ModBlockStateProperties.PARTS_1_4;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final Map<Direction, List<VoxelShape>> SHAPES = new ImmutableMap.Builder().put((Object)Direction.UP, Arrays.asList(Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0))).put((Object)Direction.DOWN, Arrays.asList(Block.m_49796_((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.m_49796_((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.m_49796_((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0))).put((Object)Direction.SOUTH, Arrays.asList(Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)4.0), Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)8.0), Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)12.0))).put((Object)Direction.NORTH, Arrays.asList(Block.m_49796_((double)3.0, (double)3.0, (double)12.0, (double)13.0, (double)13.0, (double)16.0), Block.m_49796_((double)3.0, (double)3.0, (double)8.0, (double)13.0, (double)13.0, (double)16.0), Block.m_49796_((double)3.0, (double)3.0, (double)4.0, (double)13.0, (double)13.0, (double)16.0))).put((Object)Direction.EAST, Arrays.asList(Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)4.0, (double)13.0, (double)13.0), Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)8.0, (double)13.0, (double)13.0), Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)12.0, (double)13.0, (double)13.0))).put((Object)Direction.WEST, Arrays.asList(Block.m_49796_((double)12.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), Block.m_49796_((double)8.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), Block.m_49796_((double)4.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0))).build();

    public CutPostBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PARTS, (Comparable)Integer.valueOf(1))).m_61124_((Property)FACING, (Comparable)Direction.UP)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        int parts = (Integer)state.m_61143_((Property)PARTS);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        VoxelShape shape = parts == 4 ? PostBlock.SHAPES.get(facing.m_122434_()) : SHAPES.get(facing).get(parts - 1);
        return (Boolean)state.m_61143_((Property)ATTACHED) != false ? VoxelShapeHelper.add((double)0.0, (double)-3.0, (double)0.0, (double)0.0, (double)-3.0, (double)0.0, (VoxelShape[])new VoxelShape[]{shape}) : shape;
    }

    public void m_6402_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        if (this.shouldAttach(level, pos)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(true)), 2);
        }
        super.m_6402_(level, pos, state, placer, stack);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockState state = level.m_8055_(context.m_8083_());
        if (state.m_60713_((Block)this)) {
            return (BlockState)state.m_61124_((Property)PARTS, (Comparable)Integer.valueOf(Math.min(4, (Integer)state.m_61143_((Property)PARTS) + 1)));
        }
        boolean flag = level.m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction direction, @Nonnull BlockState neighborState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_6217_().m_5945_(currentPos, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean m_6864_(@Nonnull BlockState state, @Nonnull BlockPlaceContext context) {
        return !context.m_7078_() && context.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)PARTS) < 4 || super.m_6864_(state, context);
    }

    private boolean shouldAttach(Level world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)world, pos.m_7495_(), Direction.UP) && ((Direction)world.m_8055_(pos).m_61143_((Property)FACING)).m_122434_() != Direction.Axis.Y;
    }

    @Nonnull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ATTACHED, PARTS, FACING, WATERLOGGED});
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull PathComputationType type) {
        return false;
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

