/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.block;

import com.stal111.valhelsia_structures.common.block.entity.JarBlockEntity;
import com.stal111.valhelsia_structures.common.block.properties.ModBlockStateProperties;
import com.stal111.valhelsia_structures.utils.ModTags;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import net.valhelsia.valhelsia_core.common.helper.VoxelShapeHelper;

public class JarBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final BooleanProperty TREASURE = ModBlockStateProperties.TREASURE;
    public static final BooleanProperty ROTATED = ModBlockStateProperties.ROTATED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = VoxelShapeHelper.combineAll((VoxelShape[])new VoxelShape[]{Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0), Block.m_49796_((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0), Block.m_49796_((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0)});

    public JarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)TREASURE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ROTATED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new JarBlockEntity(pos, state);
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof JarBlockEntity)) {
            return InteractionResult.PASS;
        }
        JarBlockEntity jarBlockEntity = (JarBlockEntity)blockEntity;
        boolean canBePotted = this.canBePotted(Block.m_49814_((Item)stack.m_41720_()));
        if (!canBePotted && jarBlockEntity.hasPlant()) {
            ItemStack flowerStack = jarBlockEntity.getPlant();
            if (stack.m_41619_()) {
                player.m_21008_(hand, flowerStack);
            } else if (!player.m_36356_(flowerStack)) {
                player.m_36176_(flowerStack, false);
            }
            jarBlockEntity.setPlant(ItemStack.f_41583_);
        } else if (canBePotted && !jarBlockEntity.hasPlant()) {
            jarBlockEntity.setPlant(stack.m_41777_().m_41620_(1));
            player.m_36220_(Stats.f_12961_);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        } else {
            return InteractionResult.PASS;
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    private boolean canBePotted(Block block) {
        ResourceLocation registryName = Objects.requireNonNull(block.getRegistryName());
        boolean flag = BlockTags.f_13045_.m_6497_().contains(ForgeRegistries.BLOCKS.getValue(new ResourceLocation(registryName.m_135827_(), "potted_" + registryName.m_135815_())));
        return flag && !ModTags.Items.JAR_BLACKLISTED.m_8110_((Object)block.m_5456_());
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)ROTATED, (Comparable)Boolean.valueOf((Mth.m_14107_((double)((double)((180.0f + context.m_7074_()) * 8.0f / 360.0f) + 0.5)) & 7) % 2 != 0));
    }

    private void dropPlant(Level level, BlockPos pos) {
        JarBlockEntity jarBlockEntity;
        if (level.m_5776_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        BlockEntity blockEntity2 = blockEntity;
        if (blockEntity2 instanceof JarBlockEntity && (jarBlockEntity = (JarBlockEntity)blockEntity2).hasPlant()) {
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)jarBlockEntity.getPlant());
        }
    }

    public void m_6810_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            this.dropPlant(level, pos);
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction direction, @Nonnull BlockState neighborState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_6217_().m_5945_(currentPos, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TREASURE, ROTATED, WATERLOGGED});
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

