/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.block;

import com.google.common.collect.ImmutableMap;
import com.stal111.valhelsia_structures.common.block.properties.ModBlockStateProperties;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import net.valhelsia.valhelsia_core.common.helper.VoxelShapeHelper;

public class PostBlock
extends RotatedPillarBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty ATTACHED = ModBlockStateProperties.ATTACHED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final Supplier<? extends Block> logBlock;
    public static final Map<Direction.Axis, VoxelShape> SHAPES = ImmutableMap.of((Object)Direction.Axis.Y, (Object)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (Object)Direction.Axis.Z, (Object)Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0), (Object)Direction.Axis.X, (Object)Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));

    public PostBlock(Supplier<? extends Block> logBlock) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)logBlock.get())).m_60955_());
        this.logBlock = logBlock;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public PostBlock(ResourceLocation logBlock, BlockBehaviour.Properties properties) {
        super(properties.m_60955_());
        this.logBlock = () -> (Block)ForgeRegistries.BLOCKS.getValue(logBlock);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        VoxelShape shape = SHAPES.get(state.m_61143_((Property)f_55923_));
        return (Boolean)state.m_61143_((Property)ATTACHED) != false ? VoxelShapeHelper.add((double)0.0, (double)-3.0, (double)0.0, (double)0.0, (double)-3.0, (double)0.0, (VoxelShape[])new VoxelShape[]{shape}) : shape;
    }

    public Block getLogBlock() {
        return this.logBlock.get();
    }

    public void m_6402_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        if (this.shouldAttach(level, pos)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(true)), 2);
        }
        super.m_6402_(level, pos, state, placer, stack);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean flag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)Objects.requireNonNull(super.m_5573_(context)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_6217_().m_5945_(currentPos, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    private boolean shouldAttach(Level world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)world, pos.m_7495_(), Direction.UP) && world.m_8055_(pos).m_61143_((Property)f_55923_) != Direction.Axis.Y;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ATTACHED, f_55923_, WATERLOGGED});
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull PathComputationType type) {
        return false;
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }
}

