/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.event;

import com.stal111.valhelsia_structures.common.world.structures.AbstractValhelsiaStructure;
import com.stal111.valhelsia_structures.core.config.ModConfig;
import com.stal111.valhelsia_structures.core.config.StructureConfigEntry;
import com.stal111.valhelsia_structures.core.init.ModStructures;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.valhelsia.valhelsia_core.common.world.IValhelsiaStructure;

@Mod.EventBusSubscriber
public class WorldLoadListener {
    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            ChunkGenerator generator = level.m_7726_().m_8481_();
            if (generator instanceof FlatLevelSource && level.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            HashMap<AbstractValhelsiaStructure, StructureFeatureConfiguration> tempMap = new HashMap<AbstractValhelsiaStructure, StructureFeatureConfiguration>(generator.m_62205_().m_64590_());
            ResourceLocation currDimension = level.m_46472_().m_135782_();
            for (String dimension : (List)ModConfig.COMMON.blacklistedDimensions.get()) {
                if (!dimension.equals(currDimension.toString())) {
                    if (!WorldLoadListener.checkWildcard(dimension, currDimension.toString())) continue;
                }
                ModStructures.MOD_STRUCTURES.stream().map(IValhelsiaStructure::getStructure).collect(Collectors.toList()).forEach(tempMap.keySet()::remove);
                generator.m_62205_().f_64582_ = tempMap;
                return;
            }
            for (IValhelsiaStructure iStructure : ModStructures.MOD_STRUCTURES) {
                AbstractValhelsiaStructure structure = (AbstractValhelsiaStructure)iStructure.getStructure();
                StructureConfigEntry configEntry = structure.getStructureConfigEntry();
                if (WorldLoadListener.checkDimension((List)configEntry.configuredBlacklistedDimensions.get(), currDimension)) {
                    tempMap.putIfAbsent(structure, (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)structure));
                    continue;
                }
                tempMap.keySet().remove((Object)structure);
            }
            generator.m_62205_().f_64582_ = tempMap;
        }
    }

    private static boolean checkWildcard(String blacklistedDimension, String dimension) {
        if (blacklistedDimension.startsWith("*") && blacklistedDimension.endsWith("*")) {
            return dimension.contains(blacklistedDimension.substring(1, blacklistedDimension.length() - 1));
        }
        if (blacklistedDimension.startsWith("*")) {
            return dimension.endsWith(blacklistedDimension.substring(1));
        }
        if (blacklistedDimension.endsWith("*")) {
            return dimension.startsWith(blacklistedDimension.substring(0, blacklistedDimension.length() - 1));
        }
        return false;
    }

    private static boolean checkDimension(List<? extends String> blacklistedDimensions, ResourceLocation name) {
        boolean flag = true;
        if (!blacklistedDimensions.isEmpty()) {
            boolean bl = flag = !blacklistedDimensions.contains(name.toString());
            if (flag) {
                for (String string : blacklistedDimensions) {
                    if (!WorldLoadListener.checkWildcard(string, name.toString())) continue;
                    flag = false;
                    break;
                }
            }
        }
        return flag;
    }
}

