/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.stal111.valhelsia_structures.core.init.ModRecipes;
import com.stal111.valhelsia_structures.utils.ModTags;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AxeCraftingRecipe
extends CustomRecipe {
    private final Ingredient input;
    private final ItemStack output;
    private final int count;

    public AxeCraftingRecipe(ResourceLocation recipeId, Ingredient input, ItemStack output) {
        super(recipeId);
        this.input = input;
        this.output = output;
        this.count = output.m_41613_();
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level level) {
        int axeSlot = -1;
        ItemStack stack = null;
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            Item item = inv.m_8020_(slot).m_41720_();
            if (!(item instanceof AxeItem) || ModTags.Items.AXE_CRAFTING_BLACKLISTED.m_8110_((Object)item)) continue;
            axeSlot = slot;
            break;
        }
        if (axeSlot == -1) {
            return false;
        }
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack1 = inv.m_8020_(i);
            if (i == axeSlot || stack1.m_41619_()) continue;
            if (this.input.test(stack1) && (stack == null || stack.m_41656_(stack1))) {
                stack = stack1;
                continue;
            }
            return false;
        }
        return stack != null;
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv) {
        int logCount = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!this.input.test(stack)) continue;
            ++logCount;
        }
        return new ItemStack((ItemLike)this.output.m_41720_(), logCount * this.count);
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        int i;
        NonNullList itemStacks = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        int logCount = 0;
        for (i = 0; i < itemStacks.size(); ++i) {
            if (!this.input.test(inv.m_8020_(i))) continue;
            ++logCount;
        }
        for (i = 0; i < itemStacks.size(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (!(stack.m_41720_() instanceof AxeItem)) continue;
            ItemStack stack1 = stack.m_41777_();
            stack1.m_41721_(stack1.m_41773_() + logCount);
            if (stack1.m_41773_() >= stack1.m_41776_()) continue;
            itemStacks.set(i, (Object)stack1);
        }
        return itemStacks;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.AXE_CRAFTING_SERIALIZER.get();
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<AxeCraftingRecipe> {
        @Nonnull
        public AxeCraftingRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject serializedRecipe) {
            Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"input"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"output"));
            return new AxeCraftingRecipe(recipeId, input, output);
        }

        @Nullable
        public AxeCraftingRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            return new AxeCraftingRecipe(recipeId, input, output);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull AxeCraftingRecipe recipe) {
            recipe.input.m_43923_(buffer);
            buffer.m_130055_(recipe.output);
        }
    }
}

