/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.world.structures;

import com.mojang.serialization.Codec;
import com.stal111.valhelsia_structures.core.config.ModConfig;
import com.stal111.valhelsia_structures.core.config.StructureConfigEntry;
import com.stal111.valhelsia_structures.core.init.ModStructures;
import com.stal111.valhelsia_structures.utils.StructureUtils;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.NoiseAffectingStructureStart;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.valhelsia.valhelsia_core.common.world.IValhelsiaStructure;
import net.valhelsia.valhelsia_core.common.world.ValhelsiaJigsawStructure;

public abstract class AbstractValhelsiaStructure
extends ValhelsiaJigsawStructure {
    private final int size;
    private final StructureConfigEntry structureConfigEntry;

    public AbstractValhelsiaStructure(Codec<JigsawConfiguration> codec, String name, int size, StructureConfigEntry structureConfigEntry) {
        super(codec, name);
        this.size = size;
        this.structureConfigEntry = structureConfigEntry;
    }

    protected boolean isFeatureChunk(@Nonnull ChunkGenerator generator, @Nonnull BiomeSource provider, long seed, @Nonnull WorldgenRandom rand, @Nonnull ChunkPos chunkPos, @Nonnull Biome biome, @Nonnull ChunkPos potentialPos, @Nonnull JigsawConfiguration config, @Nonnull LevelHeightAccessor heightAccessor) {
        BlockPos pos = chunkPos.m_45615_();
        if (this.checkSurface() && !this.isSurfaceFlat(generator, pos.m_123341_(), pos.m_123343_(), heightAccessor)) {
            return false;
        }
        if (!this.canGenerateOnWater()) {
            int landHeight = generator.m_156179_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor);
            NoiseColumn columnOfBlocks = generator.m_141914_(pos.m_123341_(), pos.m_123343_(), heightAccessor);
            BlockState topBlock = columnOfBlocks.m_47156_(pos.m_6630_(landHeight));
            if (!topBlock.m_60819_().m_76178_()) {
                return false;
            }
        }
        if (this.m_67095_() == GenerationStep.Decoration.SURFACE_STRUCTURES) {
            ArrayList structures = new ArrayList();
            for (IValhelsiaStructure iStructure : ModStructures.MOD_STRUCTURES) {
                StructureFeature structure = iStructure.getStructure();
                if (structure.m_67095_() != this.m_67095_()) continue;
                structures.add(structure);
            }
            structures.add(StructureFeature.f_67028_);
            if (!StructureUtils.checkForOtherStructures(this, generator, seed, rand, chunkPos, structures)) {
                return false;
            }
        }
        return rand.nextDouble() < this.getSpawnChance();
    }

    @Nonnull
    public String m_67098_() {
        return new ResourceLocation("valhelsia_structures", this.getName()).toString();
    }

    protected boolean isSurfaceFlat(@Nonnull ChunkGenerator generator, int posX, int posZ, LevelHeightAccessor level) {
        int offset = this.getSize() * 16 / 2;
        int height1 = generator.m_142647_(posX, posZ, Heightmap.Types.WORLD_SURFACE_WG, level);
        int height2 = generator.m_142647_(posX, posZ + offset, Heightmap.Types.WORLD_SURFACE_WG, level);
        int height3 = generator.m_142647_(posX + offset, posZ, Heightmap.Types.WORLD_SURFACE_WG, level);
        int height4 = generator.m_142647_(posX + offset, posZ + offset, Heightmap.Types.WORLD_SURFACE_WG, level);
        int minHeight = Math.min(Math.min(height1, height2), Math.min(height3, height4));
        int maxHeight = Math.max(Math.max(height1, height2), Math.max(height3, height4));
        return Math.abs(maxHeight - minHeight) <= (Integer)ModConfig.COMMON.flatnessDelta.get();
    }

    @Nonnull
    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public boolean transformsSurroundingLand() {
        return true;
    }

    public int getSize() {
        return this.size;
    }

    public StructureConfigEntry getStructureConfigEntry() {
        return this.structureConfigEntry;
    }

    public int getSpacing() {
        return Math.max((Integer)this.getStructureConfigEntry().configuredSpacing.get(), this.getSeparation() + 1);
    }

    public int getSeparation() {
        return (Integer)this.getStructureConfigEntry().configuredSeparation.get();
    }

    public abstract int getSeedModifier();

    public StructureFeatureConfiguration getFeatureConfiguration() {
        return new StructureFeatureConfiguration(this.getSpacing(), this.getSeparation(), this.getSeedModifier());
    }

    public double getSpawnChance() {
        return (Double)this.getStructureConfigEntry().configuredSpawnChance.get();
    }

    public abstract ConfiguredStructureFeature<JigsawConfiguration, ? extends StructureFeature<JigsawConfiguration>> getStructureFeature();

    public boolean checkSurface() {
        return true;
    }

    public boolean canGenerateOnWater() {
        return false;
    }

    public boolean hasMargin() {
        return true;
    }

    public int getMargin() {
        return 12;
    }

    @Nonnull
    public StructureFeature.StructureStartFactory<JigsawConfiguration> m_6258_() {
        return Start::new;
    }

    public int getGenerationHeight() {
        return -1;
    }

    public static class Start
    extends NoiseAffectingStructureStart<JigsawConfiguration> {
        private final StructureFeature<JigsawConfiguration> structure;
        private final int height;

        public Start(StructureFeature<JigsawConfiguration> structure, ChunkPos chunkPos, int reference, long seed) {
            this(structure, chunkPos, reference, seed, ((AbstractValhelsiaStructure)structure).getGenerationHeight());
        }

        public Start(StructureFeature<JigsawConfiguration> structure, ChunkPos chunkPos, int reference, long seed, int height) {
            super(structure, chunkPos, reference, seed);
            this.structure = structure;
            this.height = height;
        }

        public void generatePieces(@Nonnull RegistryAccess registryAccess, @Nonnull ChunkGenerator chunkGenerator, @Nonnull StructureManager structureManager, @Nonnull ChunkPos chunkPos, @Nonnull Biome biome, @Nonnull JigsawConfiguration config, @Nonnull LevelHeightAccessor level) {
            BlockPos pos = chunkPos.m_45615_();
            JigsawPlacement.m_161612_((RegistryAccess)registryAccess, (JigsawConfiguration)config, PoolElementStructurePiece::new, (ChunkGenerator)chunkGenerator, (StructureManager)structureManager, (BlockPos)pos, (StructurePieceAccessor)this, (Random)this.f_73564_, (boolean)true, (boolean)true, (LevelHeightAccessor)level);
            BlockPos structureCenter = ((StructurePiece)this.f_73562_.get(0)).m_73547_().m_162394_();
            for (StructurePiece piece : this.f_73562_) {
                piece.m_6324_(pos.m_123341_() - structureCenter.m_123341_(), 0, pos.m_123343_() - structureCenter.m_123343_());
            }
            this.m_73601_();
            if (this.height != -1) {
                int offset = this.height - this.m_73601_().m_162396_();
                this.m_73601_().m_162367_(0, offset, 0);
                for (StructurePiece piece : this.f_73562_) {
                    piece.m_6324_(0, offset, 0);
                }
            }
        }
    }
}

