/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.core.config;

import com.stal111.valhelsia_structures.common.world.structures.AbstractValhelsiaStructure;
import com.stal111.valhelsia_structures.core.config.ModConfig;
import com.stal111.valhelsia_structures.core.config.StructureConfigEntry;
import com.stal111.valhelsia_structures.core.init.ModStructures;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import net.valhelsia.valhelsia_core.common.world.IValhelsiaStructure;
import net.valhelsia.valhelsia_core.core.config.AbstractConfigValidator;

public class ConfigValidator
extends AbstractConfigValidator {
    public void validate() {
        for (IValhelsiaStructure iStructure : ModStructures.MOD_STRUCTURES) {
            AbstractValhelsiaStructure structure = (AbstractValhelsiaStructure)iStructure.getStructure();
            StructureConfigEntry configEntry = structure.getStructureConfigEntry();
            if ((Integer)configEntry.configuredSpacing.get() - (Integer)configEntry.configuredSeparation.get() <= 0) {
                this.addError((MutableComponent)new TranslatableComponent("gui.valhelsia_structures.config.spacing_error"), "structures." + structure.getName() + ".spacing", (MutableComponent)new TranslatableComponent("gui.valhelsia_structures.config.spacing_solution", new Object[]{(Integer)configEntry.configuredSeparation.get() + 1}));
            }
            for (String string : (List)configEntry.configuredBiomeCategories.get()) {
                if (!Arrays.stream(Biome.BiomeCategory.values()).noneMatch(category -> category.m_47645_().equals(string))) continue;
                this.addError(new TranslatableComponent("gui.valhelsia_structures.config.invalid_biome_category").m_130946_(" " + string), "structures." + structure.getName() + ".biome_categories", (MutableComponent)new TranslatableComponent("gui.valhelsia_core.config.ignoring"));
            }
            for (String biome : (List)configEntry.configuredBlacklistedBiomes.get()) {
                if (biome.contains("*") || ForgeRegistries.BIOMES.containsKey(new ResourceLocation(biome))) continue;
                this.addError(new TranslatableComponent("gui.valhelsia_structures.config.invalid_blacklisted_biome").m_130946_(" " + biome), "structures." + structure.getName() + ".blacklisted_biomes", (MutableComponent)new TranslatableComponent("gui.valhelsia_core.config.ignoring"));
            }
        }
        for (String biome : (List)ModConfig.COMMON.blacklistedBiomes.get()) {
            if (biome.contains("*") || ForgeRegistries.BIOMES.containsKey(new ResourceLocation(biome))) continue;
            this.addError(new TranslatableComponent("gui.valhelsia_structures.config.invalid_blacklisted_biome").m_130946_(" " + biome), "structures.global.blacklisted_biomes", (MutableComponent)new TranslatableComponent("gui.valhelsia_core.config.ignoring"));
        }
    }
}

