/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.registries.ForgeRegistries;

public class StructureUtils {
    public static boolean checkForOtherStructures(StructureFeature<?> structure, ChunkGenerator generator, long seed, WorldgenRandom rand, ChunkPos pos, List<StructureFeature<?>> structures) {
        for (StructureFeature<?> structure1 : structures) {
            StructureFeatureConfiguration featureConfiguration = generator.m_62205_().m_64593_(structure1);
            if (featureConfiguration == null || structure == structure1) continue;
            for (int x = pos.f_45578_ - 5; x <= pos.f_45578_ + 5; ++x) {
                for (int z = pos.f_45579_ - 5; z <= pos.f_45579_ + 5; ++z) {
                    ChunkPos structurePos = structure1.m_67067_(featureConfiguration, seed, rand, x, z);
                    if (x != structurePos.f_45578_ || z != structurePos.f_45579_) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static List<String> getAllBiomesForCategory(Biome.BiomeCategory ... categories) {
        ArrayList<String> biomes = new ArrayList<String>();
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            for (Biome.BiomeCategory category : categories) {
                if (biome.m_47567_() != category) continue;
                biomes.add(Objects.requireNonNull(biome.getRegistryName()).toString());
            }
        }
        return biomes;
    }
}

