/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.util;

import com.google.common.hash.Hashing;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.FilenameUtils;

public class TextureDownloader {
    public static final ResourceLocation EMPTY_TEXTURE = new ResourceLocation("valhelsia_core", "empty");
    private static final Map<String, ResourceLocation> LOADED_TEXTURES = new HashMap<String, ResourceLocation>();

    public static void downloadTextureNoFallback(String url, String path, @Nullable TextureAvailableCallback textureAvailableCallback) {
        TextureDownloader.downloadTexture(url, path, null, EMPTY_TEXTURE, textureAvailableCallback);
    }

    public static void downloadTexture(String url, String path, ResourceLocation textureFallback, @Nullable TextureAvailableCallback textureAvailableCallback) {
        TextureDownloader.downloadTexture(url, path, null, textureFallback, textureAvailableCallback);
    }

    public static void downloadTexture(String url, String path, @Nullable String identifier, ResourceLocation textureFallback, @Nullable TextureAvailableCallback textureAvailableCallback) {
        Runnable runnable = () -> Minecraft.m_91087_().execute(() -> RenderSystem.m_69879_(() -> {
            String s = Hashing.sha1().hashUnencodedChars((CharSequence)(FilenameUtils.getPath((String)url) + FilenameUtils.getBaseName((String)url))).toString();
            ResourceLocation resourceLocation = new ResourceLocation("valhelsia_core", path + s);
            TextureManager textureManager = Minecraft.m_91087_().m_91097_();
            AbstractTexture texture = textureManager.m_174786_(resourceLocation, (AbstractTexture)MissingTextureAtlasSprite.m_118080_());
            if (texture == MissingTextureAtlasSprite.m_118080_()) {
                File file1 = new File(new File(Minecraft.m_91087_().f_91069_, "assets/"), s.length() > 2 ? s.substring(0, 2) : "xx");
                File file2 = new File(file1, s);
                HttpTexture httpTexture = new HttpTexture(file2, url, textureFallback, false, null);
                textureManager.m_118495_(resourceLocation, (AbstractTexture)httpTexture);
            }
            if (identifier != null) {
                LOADED_TEXTURES.put(identifier, resourceLocation);
            }
            if (textureAvailableCallback != null) {
                textureAvailableCallback.onTextureAvailable(resourceLocation);
            }
        }));
        Util.m_183991_().execute(runnable);
    }

    public static ResourceLocation getTexture(String identifier) {
        return LOADED_TEXTURES.getOrDefault(identifier, null);
    }

    public static interface TextureAvailableCallback {
        public void onTextureAvailable(ResourceLocation var1);
    }
}

