/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.common.loot.conditions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.registries.ForgeRegistries;
import net.valhelsia.valhelsia_core.core.init.ValhelsiaLootConditions;

public record MatchBlockCondition(@Nullable List<Block> blocks, @Nullable Tag.Named<Block> tag, @Nullable StatePropertiesPredicate properties) implements LootItemCondition
{
    public static LootItemCondition.Builder builder(List<Block> blocks) {
        return () -> new MatchBlockCondition(blocks, null, null);
    }

    public static LootItemCondition.Builder builder(Tag.Named<Block> tag) {
        return () -> new MatchBlockCondition(null, tag, null);
    }

    public static LootItemCondition.Builder builder(List<Block> blocks, Tag.Named<Block> tag) {
        return () -> new MatchBlockCondition(blocks, tag, null);
    }

    public static LootItemCondition.Builder builder(List<Block> blocks, Tag.Named<Block> tag, StatePropertiesPredicate properties) {
        return () -> new MatchBlockCondition(blocks, tag, properties);
    }

    @Nonnull
    public LootItemConditionType m_7940_() {
        return ValhelsiaLootConditions.MATCH_BLOCK;
    }

    @Nonnull
    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81461_);
    }

    public boolean test(LootContext lootContext) {
        if (!lootContext.m_78936_(LootContextParams.f_81461_)) {
            return false;
        }
        BlockState state = (BlockState)lootContext.m_165124_(LootContextParams.f_81461_);
        boolean flag = false;
        if (this.tag != null) {
            flag = this.tag.m_8110_((Object)state.m_60734_());
        }
        if (this.blocks != null && !flag) {
            flag = this.blocks.contains(state.m_60734_());
        }
        if (this.properties != null) {
            flag = this.properties.m_67667_(state);
        }
        return flag;
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<MatchBlockCondition> {
        public void serialize(@Nonnull JsonObject jsonObject, MatchBlockCondition instance, @Nonnull JsonSerializationContext context) {
            if (instance.tag != null) {
                jsonObject.addProperty("tag", instance.tag.m_6979_().toString());
            }
            if (instance.properties != null) {
                jsonObject.add("properties", instance.properties.m_67666_());
            }
        }

        @Nonnull
        public MatchBlockCondition deserialize(JsonObject jsonObject, @Nonnull JsonDeserializationContext context) {
            if (jsonObject.has("tag")) {
                ResourceLocation tag = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"tag"));
                return new MatchBlockCondition(null, (Tag.Named<Block>)BlockTags.createOptional((ResourceLocation)tag), this.deserializeProperties(jsonObject));
            }
            if (jsonObject.has("blocks")) {
                ArrayList<Block> blocks = new ArrayList<Block>();
                for (JsonElement e : GsonHelper.m_13933_((JsonObject)jsonObject, (String)"blocks")) {
                    ResourceLocation blockName = new ResourceLocation(e.getAsString());
                    blocks.add((Block)ForgeRegistries.BLOCKS.getValue(blockName));
                }
                return new MatchBlockCondition(blocks, null, this.deserializeProperties(jsonObject));
            }
            if (jsonObject.has("block")) {
                ResourceLocation block = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"block"));
                return new MatchBlockCondition(Collections.singletonList((Block)ForgeRegistries.BLOCKS.getValue(block)), null, this.deserializeProperties(jsonObject));
            }
            throw new RuntimeException("match_block must have one of 'tag', 'block' or 'blocks' key");
        }

        private StatePropertiesPredicate deserializeProperties(JsonObject jsonObject) {
            if (jsonObject.has("properties")) {
                return StatePropertiesPredicate.m_67679_((JsonElement)jsonObject.get("properties"));
            }
            return null;
        }
    }
}

