/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.core.registry;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.valhelsia.valhelsia_core.core.ValhelsiaCore;
import net.valhelsia.valhelsia_core.core.config.AbstractConfigValidator;
import net.valhelsia.valhelsia_core.core.registry.AbstractRegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.EntityRegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.ItemRegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.block.BlockRegistryHelper;

public class RegistryManager {
    private final Map<IForgeRegistry<?>, AbstractRegistryHelper<?>> helpers = new HashMap();
    private final String modId;
    private AbstractConfigValidator configValidator = null;

    private RegistryManager(String modId) {
        this.modId = modId;
    }

    public String getModId() {
        return this.modId;
    }

    public boolean hasHelper(IForgeRegistry<?> forgeRegistry) {
        return this.helpers.containsKey(forgeRegistry);
    }

    private void addHelper(AbstractRegistryHelper<?> registryHelper) {
        this.helpers.put(registryHelper.getRegistry(), registryHelper);
    }

    public AbstractRegistryHelper<?> getHelper(IForgeRegistry<?> forgeRegistry) {
        if (!this.hasHelper(forgeRegistry)) {
            throw new NullPointerException("Registry Manager for '" + this.getModId() + "' has no Helper for registry: " + forgeRegistry);
        }
        return this.helpers.get(forgeRegistry);
    }

    public ItemRegistryHelper getItemHelper() {
        return (ItemRegistryHelper)this.getHelper(ForgeRegistries.ITEMS);
    }

    public BlockRegistryHelper getBlockHelper() {
        return (BlockRegistryHelper)this.getHelper(ForgeRegistries.BLOCKS);
    }

    public EntityRegistryHelper getEntityHelper() {
        return (EntityRegistryHelper)this.getHelper(ForgeRegistries.ENTITIES);
    }

    public void register(IEventBus eventBus) {
        this.helpers.forEach((forgeRegistry, abstractRegistryHelper) -> abstractRegistryHelper.register(eventBus));
    }

    public void registerConfigValidator(AbstractConfigValidator configValidator) {
        this.configValidator = configValidator;
    }

    @Nullable
    public AbstractConfigValidator getConfigValidator() {
        return this.configValidator;
    }

    public static class Builder {
        private final RegistryManager registryManager;

        public Builder(String modId) {
            this.registryManager = new RegistryManager(modId);
        }

        public Builder addDefaultHelpers() {
            return this.addHelpers(new ItemRegistryHelper(), new BlockRegistryHelper());
        }

        public Builder addHelpers(AbstractRegistryHelper<?> ... registryHelpers) {
            for (AbstractRegistryHelper<?> registryHelper : registryHelpers) {
                registryHelper.setRegistryManager(this.registryManager);
                registryHelper.createDeferredRegister();
                this.registryManager.addHelper(registryHelper);
            }
            return this;
        }

        public RegistryManager build() {
            ValhelsiaCore.REGISTRY_MANAGERS.add(this.registryManager);
            return this.registryManager;
        }
    }
}

