/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.core.registry.block;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.valhelsia.valhelsia_core.client.util.ValhelsiaRenderType;
import net.valhelsia.valhelsia_core.common.block.ValhelsiaStandingSignBlock;
import net.valhelsia.valhelsia_core.common.block.ValhelsiaWallSignBlock;
import net.valhelsia.valhelsia_core.core.registry.AbstractRegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.ItemRegistryHelper;
import net.valhelsia.valhelsia_core.core.registry.block.CompostableHelper;
import net.valhelsia.valhelsia_core.core.registry.block.FlammableHelper;

public class BlockRegistryHelper
extends AbstractRegistryHelper<Block> {
    public final Map<ValhelsiaRenderType, List<Block>> renderTypes = new HashMap<ValhelsiaRenderType, List<Block>>();
    public final List<RegistryObject<? extends SignBlock>> signBlocks = new ArrayList<RegistryObject<? extends SignBlock>>();
    private CreativeModeTab defaultCreativeTab = null;
    private final FlammableHelper flammableHelper = new FlammableHelper();
    private final CompostableHelper compostableHelper = new CompostableHelper();

    @Override
    public IForgeRegistry<Block> getRegistry() {
        return ForgeRegistries.BLOCKS;
    }

    public void setDefaultGroup(CreativeModeTab creativeModeTab) {
        this.defaultCreativeTab = creativeModeTab;
    }

    public CreativeModeTab getDefaultCreativeTab() {
        return this.defaultCreativeTab;
    }

    public ItemRegistryHelper getItemRegistryHelper() {
        return this.getRegistryManager().getItemHelper();
    }

    public FlammableHelper getFlammableHelper() {
        return this.flammableHelper;
    }

    public CompostableHelper getCompostableHelper() {
        return this.compostableHelper;
    }

    public <T extends Block> RegistryObject<T> register(String name, T block) {
        return this.register(name, block, true, this.getDefaultCreativeTab());
    }

    public <T extends Block> RegistryObject<T> register(String name, T block, ValhelsiaRenderType renderType) {
        return this.register(name, block, true, this.getDefaultCreativeTab(), renderType);
    }

    public <T extends Block> RegistryObject<T> register(String name, T block, CreativeModeTab itemGroup) {
        return this.register(name, block, true, itemGroup);
    }

    public <T extends Block> RegistryObject<T> registerNoItem(String name, T block) {
        return this.register(name, block, false);
    }

    public <T extends Block> RegistryObject<T> registerNoItem(String name, T block, ValhelsiaRenderType valhelsiaRenderType) {
        return this.register(name, block, false, this.getDefaultCreativeTab(), valhelsiaRenderType);
    }

    public <T extends Block> RegistryObject<T> register(String name, T block, boolean item) {
        return this.register(name, block, item, this.getDefaultCreativeTab());
    }

    public <T extends Block> RegistryObject<T> register(String name, T block, boolean item, CreativeModeTab creativeModeTab) {
        return this.register(name, block, item, creativeModeTab, ValhelsiaRenderType.SOLID);
    }

    public <T extends Block> RegistryObject<T> register(String name, T block, boolean item, CreativeModeTab creativeModeTab, ValhelsiaRenderType renderType) {
        if (item) {
            return this.register(name, block, block1 -> new BlockItem(block1, new Item.Properties().m_41491_(creativeModeTab)), renderType);
        }
        return this.registerBlock(name, block, renderType);
    }

    public <T extends Block> RegistryObject<T> register(String name, T block, Function<T, BlockItem> blockItemFunction) {
        return this.register(name, block, blockItemFunction, ValhelsiaRenderType.SOLID);
    }

    public <T extends Block> RegistryObject<T> register(String name, T block, Function<T, BlockItem> blockItemFunction, ValhelsiaRenderType renderType) {
        this.getItemRegistryHelper().register(name, () -> (BlockItem)blockItemFunction.apply(block));
        return this.registerBlock(name, block, renderType);
    }

    private <T extends Block> RegistryObject<T> registerBlock(String name, T block, ValhelsiaRenderType renderType) {
        if (renderType != ValhelsiaRenderType.SOLID) {
            this.renderTypes.computeIfAbsent(renderType, k -> new ArrayList());
            this.renderTypes.get((Object)renderType).add(block);
        }
        return this.deferredRegister.register(name, () -> block);
    }

    public RegistryObject<RotatedPillarBlock> registerLogBlock(String name, MaterialColor topColor, MaterialColor barkColor) {
        return this.register(name, new RotatedPillarBlock(BlockBehaviour.Properties.m_60947_((Material)Material.f_76320_, state -> state.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? topColor : barkColor).m_60978_(2.0f).m_60918_(SoundType.f_56736_)), true, this.getDefaultCreativeTab());
    }

    public Pair<RegistryObject<ValhelsiaStandingSignBlock>, RegistryObject<ValhelsiaWallSignBlock>> createSignBlock(String name, MaterialColor color, WoodType woodType) {
        RegistryObject standing = this.deferredRegister.register(name + "_sign", () -> new ValhelsiaStandingSignBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_), woodType));
        RegistryObject wall = this.deferredRegister.register(name + "_wall_sign", () -> new ValhelsiaWallSignBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)color).m_60910_().m_60978_(1.0f).m_60918_(SoundType.f_56736_).lootFrom((Supplier)standing), woodType));
        this.signBlocks.add((RegistryObject<? extends SignBlock>)standing);
        this.signBlocks.add((RegistryObject<? extends SignBlock>)wall);
        this.getItemRegistryHelper().register(name + "_sign", () -> new SignItem(new Item.Properties().m_41487_(16).m_41491_(this.getDefaultCreativeTab()), (Block)standing.get(), (Block)wall.get()));
        return Pair.of((Object)standing, (Object)wall);
    }
}

