/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.event;

import com.stal111.valhelsia_structures.common.world.structures.AbstractValhelsiaStructure;
import com.stal111.valhelsia_structures.core.config.ModConfig;
import com.stal111.valhelsia_structures.core.config.StructureConfigEntry;
import com.stal111.valhelsia_structures.core.init.ModStructures;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.valhelsia.valhelsia_core.common.world.IValhelsiaStructure;

@Mod.EventBusSubscriber
public class BiomeLoadingListener {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        ResourceLocation name = event.getName();
        Biome.BiomeCategory category = event.getCategory();
        if (name != null) {
            for (String biome : (List)ModConfig.COMMON.blacklistedBiomes.get()) {
                if (!biome.equals(name.toString()) && !BiomeLoadingListener.checkWildcard(biome, name.toString())) continue;
                return;
            }
            for (IValhelsiaStructure iStructure : ModStructures.MOD_STRUCTURES) {
                AbstractValhelsiaStructure structure = (AbstractValhelsiaStructure)iStructure.getStructure();
                StructureConfigEntry configEntry = structure.getStructureConfigEntry();
                if (((Boolean)configEntry.generate.get()).booleanValue() && !BiomeLoadingListener.checkBiome((List)configEntry.configuredBiomeCategories.get(), (List)configEntry.configuredBlacklistedBiomes.get(), name, category)) continue;
            }
        }
    }

    private static boolean checkWildcard(String blacklistedBiome, String biome) {
        if (blacklistedBiome.startsWith("*") && blacklistedBiome.endsWith("*")) {
            return biome.contains(blacklistedBiome.substring(1, blacklistedBiome.length() - 1));
        }
        if (blacklistedBiome.startsWith("*")) {
            return biome.endsWith(blacklistedBiome.substring(1));
        }
        if (blacklistedBiome.endsWith("*")) {
            return biome.startsWith(blacklistedBiome.substring(0, blacklistedBiome.length() - 1));
        }
        return false;
    }

    private static boolean checkBiome(List<? extends String> allowedBiomeCategories, List<? extends String> blacklistedBiomes, ResourceLocation name, Biome.BiomeCategory category) {
        boolean flag = allowedBiomeCategories.contains(category.m_47645_());
        if (!blacklistedBiomes.isEmpty() && flag) {
            boolean bl = flag = !blacklistedBiomes.contains(name.toString());
            if (flag) {
                for (String string : blacklistedBiomes) {
                    if (!BiomeLoadingListener.checkWildcard(string, name.toString())) continue;
                    flag = false;
                    break;
                }
            }
        }
        return flag;
    }
}

